// File: MenuDriver.h

#ifndef _menudrv_h_
#define _menudrv_h_

#include "ui/menu.h"

class MenuDriver {

public:
    MenuDriver (UI_CompositeVObject* root);
    ~MenuDriver () { delete _menu; }

#define MSGHANDLER(name)   bool name(UI_Event&, UI_ViewID);

   MSGHANDLER(OnFileOpen)
   MSGHANDLER(OnFileSave)
   MSGHANDLER(OnFileSaveAs)
   MSGHANDLER(OnFilePrint)
   MSGHANDLER(OnFileExit)
   MSGHANDLER(OnEditCut)
   MSGHANDLER(OnEditCopy)
   MSGHANDLER(OnEditPaste)
   MSGHANDLER(OnHelp)

protected:
   UI_Menu* _menu;
   bool    _fileSaved;
};

#endif

