

// ##########################################################################
// #                                                                        #
// #                             BtnNumberEditor                            #
// #                                                                        #
// #                            - Definitionen -                            #
// #                                                                        #
// ##########################################################################



#include"gui/btnnumed.h"
#include"ui/applic.h"
#include"ui/cntroler.h"
#include"base/binding.h"


typedef CL_Binding0<BtnNumberEditor> BindBtnNumberEditor;



// **************************************************************************
// *                             OBJEKT-HANDLING                            *
// **************************************************************************



// ************
// Konstruktion
// ************


BtnNumberEditor :: BtnNumberEditor(UI_VObjCollection*  parent,
											  const UI_Rectangle& shape,
											  UI_ViewID           id,
											  unsigned            range,
											  unsigned            pr,
											  char                sep,
											  bool                sgn,
											  double              stp
											 )
					  : UI_VObjCollection(parent, shape, id)
{
  long h  = shape.Height();
  long w  = shape.Width();
  Scrl    = new UI_VScrollBar  (this,
										  UI_Rectangle(w-20, 0, 20, h),
										  ID_BTNNUMED_SCR
										 );
  Editor  = new ExtNumberEditor(this,
										  UI_Rectangle(0,0,w-20,h),
										  ID_BTNNUMED_EDT,
										  range, pr, sep, sgn
										 );
  Scrl->Range() = CL_Interval(0,2);
  BindBtnNumberEditor bind  (this,&BtnNumberEditor::scroll);
  Scrl -> ClientSet().Add(bind);
  Step    = stp;
  ShowBorder ();
};


// ***********
// Destruktion
// ***********


BtnNumberEditor :: ~BtnNumberEditor()
{};


// ***************
// Initialisierung
// ***************


bool BtnNumberEditor :: _ShapeRectChanged()
{
  bool res = UI_VObjCollection::_ShapeRectChanged();
  long h  = _shape.Height();
  long w  = _shape.Width ();
  Scrl   -> Shape() = UI_Rectangle(w-20, 0, 20, h);
  Editor -> Shape() = UI_Rectangle(0,0,w-20,h);
  return res;
};


bool BtnNumberEditor :: MakeVisualElement()
{
  return UI_VObjCollection::MakeVisualElement();
};


void BtnNumberEditor :: Initialize       ()
{
  UI_VObjCollection::Initialize();
  return;
};


// ****************
// Attributszugriff
// ****************


double BtnNumberEditor :: get_Step    () const
{
  return Step;
};


void   BtnNumberEditor :: set_Step    (double s)
{
  Step = s;
  return;
};


ExtNumberEditor&       BtnNumberEditor :: editor     ()
{
  return *Editor;
};


const ExtNumberEditor& BtnNumberEditor :: editor     () const

{

  return *Editor;
};



const ExtNumberEditor& BtnNumberEditor :: get_Editor ()

{

  return *Editor;
};




// **************************************************************************
// *                            MODEL-HANDLING                              *
// **************************************************************************



bool   BtnNumberEditor :: increment()
{

  return doStep(Step);

};



bool   BtnNumberEditor :: decrement()

{

  return doStep(-Step);

};



bool   BtnNumberEditor :: doStep(double stp)

{

  double x = Editor->asDouble();

  if (Editor->initModel(x+stp))

	{

	  Editor->sendEvent();

	  return TRUE;

	}

  else {

			_Controller->Beep();

			return FALSE;

		 };

};




bool   BtnNumberEditor :: scroll()
{

  CL_Interval& Int = (CL_Interval&)(Scrl->Model());

  long pos = Int.Low();

  if (pos < 1)

	{

	  increment();

	  Int = CL_Interval(1,1);

	}

  else if (pos > 1)

		  {

			 decrement();

			 Int = CL_Interval(1,1);

		  };

  return FALSE;

};
