

// ##########################################################################
// #                                                                        #
// #                              ChildGenerator                            #
// #                                                                        #
// #                            - Deklarationen -                           #
// #                                                                        #
// ##########################################################################



#ifndef _CHILDGENERATOR_H
#define _CHILDGENERATOR_H

#include"ui/vobjcoll.h"


class ChildGenerator
{
  public:

	 bool generate    (UI_VObjCollection*   client, const UI_ViewDescriptor*);
	 bool operator () (UI_VObjCollection*   client, const UI_ViewDescriptor*);
	 bool generate    (UI_VObjCollection*   client, UI_ViewDescriptor* *);
	 bool operator () (UI_VObjCollection*   client, UI_ViewDescriptor* *);

	 bool generate    (UI_CompositeVObject* client, const UI_ViewDescriptor*);
	 bool operator () (UI_CompositeVObject* client, const UI_ViewDescriptor*);
	 bool generate    (UI_CompositeVObject* client, UI_ViewDescriptor* *);
	 bool operator () (UI_CompositeVObject* client, UI_ViewDescriptor* *);

	 bool createChild (UI_VObjCollection*   client, const UI_ViewDescriptor&);
	 bool createChild (UI_CompositeVObject* client, const UI_ViewDescriptor&);

	 virtual UI_VisualObject* create(UI_VObjCollection*,
												const UI_ViewDescriptor&);

	 bool appendRight (UI_CompositeVObject* client, UI_ViewDescriptor* children);
	 bool appendLeft  (UI_CompositeVObject* client, UI_ViewDescriptor* children);
	 bool appendBottom(UI_CompositeVObject* client, UI_ViewDescriptor* children);
	 bool appendTop   (UI_CompositeVObject* client, UI_ViewDescriptor* children);
	 void reshape     (UI_CompositeVObject* client);


  protected:

	 long maxPos      (UI_ViewDescriptor* children,
							 long UI_RectangleStruct:: * pos1,
							 long UI_RectangleStruct:: * pos2
							);
	 void shiftNew    (long UI_RectangleStruct:: * pos,
							 UI_ViewDescriptor*          children,
							 long corr
							);
	 void shiftOld    (UI_CompositeVObject* client,
							 long UI_RectangleStruct:: * pos,
							 long corr
							);

};

extern ChildGenerator ChildGen;


#endif _CHILDGENERATOR_H
