
// ##########################################################################
// #                                                                        #
// #                              EventDispatcher                           #
// #                                                                        #
// ##########################################################################



#ifndef _EVENTDISPATCHER_CPP
#define _EVENTDISPATCHER_CPP


#include"gui/eventdsp.h"



// **************************************************************************
// *                              PUBLIC-METHODEN                           *
// **************************************************************************


// *************
// Konstruktoren
// *************


template <class T>
EventDispatcher<T> :: EventDispatcher()
{};


template <class T>
EventDispatcher<T> :: EventDispatcher(T*                    Owner,
												  DispatcherStruct0<T>* Dispatcher,
												  UI_VisualObject*      VObj)
{
  dispatch(Owner,Dispatcher,VObj);
};


template <class T>
EventDispatcher<T> :: EventDispatcher(T*                    Owner,
												  DispatcherStruct1<T>* Dispatcher,
												  UI_VisualObject*      VObj)
{
  dispatch(Owner,Dispatcher,VObj);
};


template <class T>
EventDispatcher<T> :: EventDispatcher(T*                    Owner,
												  DispatcherStruct2<T>* Dispatcher,
												  UI_VisualObject*      VObj)
{
  dispatch(Owner,Dispatcher,VObj);
};


template <class T>
EventDispatcher<T> :: EventDispatcher(T*                    Owner,
												  DispatcherStruct2<T>* Dispatcher,
												  UI_VObjCollection*    VObj)
{
  dispatch(Owner,Dispatcher,VObj);
};


template <class T>
EventDispatcher<T> :: EventDispatcher(T*                    Owner,
												  DispatcherStruct2<T>* Dispatcher,
												  UI_Menu*              VObj)
{
  dispatch(Owner,Dispatcher,VObj);
};


// *************************
// Spezielle public-Methoden
// *************************


template <class T>
bool EventDispatcher<T> :: dispatch (T*                    Owner,
												 DispatcherStruct0<T>* Dispatcher,
												 UI_VisualObject*      VObj)
{
  if (Owner && Dispatcher && VObj)
	{
	  unsigned  i  = 0;
	  while (Dispatcher[i].Method!=NULL)
	  {
		 UI_EventBinding0<T> bind (Owner, Dispatcher[i].Method);
		 VObj->AddEventDependent (Dispatcher[i].Event, bind);
		 i++;
	  };
	  return TRUE;
	}
  else return FALSE;
};


template <class T>
bool EventDispatcher<T> :: dispatch (T*                    Owner,
												 DispatcherStruct1<T>* Dispatcher,
												 UI_VisualObject*      VObj)
{
  if (Owner && Dispatcher && VObj)
	{
	  unsigned  i  = 0;
	  while (Dispatcher[i].Method!=NULL)
	  {
		 UI_EventBinding1<T> bind (Owner, Dispatcher[i].Method);
		 VObj->AddEventDependent (Dispatcher[i].Event, bind);
		 i++;
	  };
	  return TRUE;
	}
  else return FALSE;
};


template <class T>
bool EventDispatcher<T> :: dispatch (T*                    Owner,
												 DispatcherStruct2<T>* Dispatcher,
												 UI_VisualObject*      VObj)
{
  if (Owner && Dispatcher && VObj)
	{
	  unsigned  i  = 0;
	  while (Dispatcher[i].Method!=NULL)
	  {
		 UI_EventBinding2<T> bind (Owner, Dispatcher[i].Method, Dispatcher[i].Id);
		 VObj->AddEventDependent (Dispatcher[i].Event, bind);
		 i++;
	  };
	  return TRUE;
	}
  else return FALSE;
};


template <class T>
bool EventDispatcher<T> :: dispatch (T*                    Owner,
												 DispatcherStruct2<T>* Dispatcher,
												 UI_VObjCollection*    VObj)
{
  if (Owner && Dispatcher && VObj)
	{
	  unsigned  i  = 0;
	  UI_ViewID id;
	  while (Dispatcher[i].Method!=NULL)
	  {
		 id = Dispatcher[i].Id;
		 UI_EventBinding2<T> bind (Owner, Dispatcher[i].Method, Dispatcher[i].Id);
		 if ((*VObj)[id])
			  (*VObj)[id]->AddEventDependent (Dispatcher[i].Event, bind);
		 i++;
	  };
	  return TRUE;
	}
  else return FALSE;
};


template <class T>
bool EventDispatcher<T> :: dispatch (T*                    Owner,
												 DispatcherStruct2<T>* Dispatcher,
												 UI_Menu*              VObj)
{
  if (Owner && Dispatcher && VObj)
	{
	  unsigned  i  = 0;
	  UI_ViewID id;
	  while (Dispatcher[i].Method!=NULL)
	  {
		 id = Dispatcher[i].Id;
		 UI_EventBinding2<T> bind (Owner, Dispatcher[i].Method, Dispatcher[i].Id);
		 if ((*VObj)[id])
			  (*VObj)[id]->AddEventDependent (Dispatcher[i].Event, bind);
		 i++;
	  };
	  return TRUE;
	}
  else return FALSE;
};


// remove


template <class T>
bool EventDispatcher<T> :: remove   (T*                    Owner,
												 DispatcherStruct0<T>* Dispatcher,
												 UI_VisualObject*      VObj)
{
  if (Owner && Dispatcher && VObj)
	{
	  unsigned  i  = 0;
	  while (Dispatcher[i].Method!=NULL)
	  {
		 UI_EventBinding0<T> bind (Owner, Dispatcher[i].Method);
		 VObj->RemoveEventDependent (Dispatcher[i].Event, bind);
		 i++;
	  };
	  return TRUE;
	}
  else return FALSE;
};


template <class T>
bool EventDispatcher<T> :: remove   (T*                    Owner,
												 DispatcherStruct1<T>* Dispatcher,
												 UI_VisualObject*      VObj)
{
  if (Owner && Dispatcher && VObj)
	{
	  unsigned  i  = 0;
	  while (Dispatcher[i].Method!=NULL)
	  {
		 UI_EventBinding1<T> bind (Owner, Dispatcher[i].Method);
		 VObj->RemoveEventDependent (Dispatcher[i].Event, bind);
		 i++;
	  };
	  return TRUE;
	}
  else return FALSE;
};


template <class T>
bool EventDispatcher<T> :: remove   (T*                    Owner,
												 DispatcherStruct2<T>* Dispatcher,
												 UI_VisualObject*      VObj)
{
  if (Owner && Dispatcher && VObj)
	{
	  unsigned  i  = 0;
	  while (Dispatcher[i].Method!=NULL)
	  {
		 UI_EventBinding2<T> bind (Owner, Dispatcher[i].Method, Dispatcher[i].Id);
		 VObj->RemoveEventDependent (Dispatcher[i].Event, bind);
		 i++;
	  };
	  return TRUE;
	}
  else return FALSE;
};


template <class T>
bool EventDispatcher<T> :: remove   (T*                    Owner,
												 DispatcherStruct2<T>* Dispatcher,
												 UI_VObjCollection*    VObj)
{
  if (Owner && Dispatcher && VObj)
	{
	  unsigned  i  = 0;
	  UI_ViewID id;
	  while (Dispatcher[i].Method!=NULL)
	  {
		 id = Dispatcher[i].Id;
		 UI_EventBinding2<T> bind (Owner, Dispatcher[i].Method, Dispatcher[i].Id);
		 if ((*VObj)[id])
			  (*VObj)[id]->RemoveEventDependent (Dispatcher[i].Event, bind);
		 i++;
	  };
	  return TRUE;
	}
  else return FALSE;
};


template <class T>
bool EventDispatcher<T> :: remove   (T*                    Owner,
												 DispatcherStruct2<T>* Dispatcher,
												 UI_Menu*              VObj)
{
  if (Owner && Dispatcher && VObj)
	{
	  unsigned  i  = 0;
	  UI_ViewID id;
	  while (Dispatcher[i].Method!=NULL)
	  {
		 id = Dispatcher[i].Id;
		 UI_EventBinding2<T> bind (Owner, Dispatcher[i].Method, Dispatcher[i].Id);
		 if ((*VObj)[id])
			  (*VObj)[id]->RemoveEventDependent (Dispatcher[i].Event, bind);
		 i++;
	  };
	  return TRUE;
	}
  else return FALSE;
};

#endif _EVENTDISPATCHER_CPP
