

// ##########################################################################
// #                                                                        #
// #                                 Group                                  #
// #                                                                        #
// #                            - Definitionen -                            #
// #                                                                        #
// ##########################################################################



#include"gui/group.h"
#include"gui/syltchgn.h"
#include"gui/stdmsg.h"
#include"ui/dsplsurf.h"



// **************************************************************************
// *                             OBJEKT-HANDLING                            *
// **************************************************************************



// ************
// Konstruktion
// ************


Group :: Group (UI_VObjCollection*       parent,
					 const UI_Rectangle&      shape,
					 UI_ViewID                id,
					 const UI_ViewDescriptor* dsc,
					 const char*              ttl,
					 unsigned                 hTtl
					)
		 : UI_VObjCollection(parent,shape,id),
			Rect(0,hTtl,shape.Width(),shape.Height()-hTtl,
				  UI_ShadowRectangle::Recessed)
{
  TtlHgt = hTtl;
  Ttl = new TextLabel(this,UI_Rectangle(0,0,shape.Width(),hTtl),ID_GRP_TTL);
  Ttl->Title() = ttl;
  _borderShown = TRUE;
  _bgColor     = UIColor_MediumGray;
  SyltChildGen(this,dsc);
};


// ***********
// Destruktion
// ***********


Group :: ~Group()
{};


// ***************
// Initialisierung
// ***************


bool Group :: MakeVisualElement()
{
  bool res = UI_VObjCollection::MakeVisualElement();
  return res;
};


void Group :: Initialize       ()
{
  UI_VObjCollection::Initialize();
  return;
};


// ****************
// Attributszugriff
// ****************


CL_String& Group :: Title()
{
  return Ttl->Title();
};


UI_ShadowRectangle& Group :: rect()
{
  return Rect;
};


bool Group :: Paint(const UI_Rectangle& r)
{

  UI_DisplaySurface& sf = CreateDisplaySurface();
  sf.ColorDisplay(_bgColor);
  bool res = UI_VObjCollection::Paint(r);
  if (_borderShown)
	  Rect.DrawOn(sf);
  DestroyDisplaySurface();
  return res;
};


bool Group :: _DoShowBorder(bool b)
{
  if (b != _borderShown)
	{
	  _borderShown = b;
	  Paint(_shape);
	  return TRUE;
	}
  else return FALSE;
};


bool Group :: ToggleBorder()
{
  return _DoShowBorder(!_borderShown);
};


bool Group :: IsBorderShown() const
{
  return _borderShown;
};



bool Group :: _ShapeRectChanged()
{
  Ttl->Shape() = UI_Rectangle(0,0,_shape.Width(),TtlHgt);
  Rect.ReshapeTo( UI_Point(0,TtlHgt),
						UI_Point(_shape.Width(),_shape.Height()-TtlHgt)
					 );
  return FALSE;
};


bool Group :: Reconfigure (const UI_Rectangle& r)
{
  _shape = r;
  return UI_VObjCollection::Reconfigure(r);
};






