// ##########################################################################
// #                                                                        #
// #                                IconWindow                              #
// #                                                                        #
// #                            - Deklarationen -                           #
// #                                                                        #
// ##########################################################################



#ifndef _iconwin_h_
#define _iconwin_h_


#include"ui/composit.h"
#include"ui/scrolbar.h"
#include"gui/icon.h"
#include"base/objseq.h"

class IconWindow: public UI_CompositeVObject
{

  public:

	  IconWindow (UI_CompositeVObject*   parent,
					  const UI_Rectangle& shape,
					  UI_ViewID           id,
					  unsigned            dist
					 );

	  // access to attributes:

	  UI_HScrollBar&           hscroll      ();
	  UI_VScrollBar&           vscroll      ();
	  unsigned&                distance     ();

	  // redefinitions of VisualObject-methods:

	  virtual const char*      ClassName    () const { return "IconWindow";};

	  // redefinitions of VisualObjCollection-methods:

	  virtual void             AddChild     (UI_VisualObject*);
	  virtual void             AddChild     (Icon*);
	  virtual Icon*            AddChild     (const IconDescriptor&);
	  virtual UI_VisualObject* RemoveChild  (UI_VisualObject*);

	  // managing icons:

	  virtual bool             selectAt     (unsigned);
	  virtual bool             unselectAt   (unsigned);
	  virtual bool             selectOnlyAt (unsigned);
	  virtual bool             selectOnly   (UI_ViewID);
	  virtual bool             selectOnly   (Icon*);
	  virtual bool             selectNext   ();
	  virtual bool             selectPrev   ();
	  virtual bool             selectAll    ();
	  virtual bool             unselectAll  ();
	  virtual bool             arrange      ();

	  virtual bool             selectAll    (UI_Event&,UI_ViewID);
	  virtual bool             unselectAll  (UI_Event&,UI_ViewID);
	  virtual bool             arrange      (UI_Event&,UI_ViewID);

	  virtual Icon*            selectedIs   () const;
	  virtual void             selectedAre  (CL_IntegerSet& set) const;
	  virtual long int         selectedIdx  () const;

	  virtual UI_Vector        newPos       (unsigned w_new);
	  virtual bool             append       (Icon*);
	  virtual bool             insertAt     (Icon*,unsigned i);
	  virtual Icon*            remove       (Icon*);
	  virtual Icon*            removeAt     (unsigned);
	  virtual void             destroyIcons ();

	  // managing scrolling:

	  virtual long int         right        ();
	  virtual long int         left         ();
	  virtual long int         bottom       ();
	  virtual long int         top          ();
	  virtual void             checkScroll  ();
	  virtual bool             scrollHorz   ();
	  virtual bool             scrollVert   ();
	  void                     reshapeScroll();


	protected:


	  // attributes:

	  unsigned                 Distance;
	  unsigned                 ScrlWdth;
	  CL_ObjectSequence        Icons;
	  UI_VScrollBar*           VScroll;
	  UI_HScrollBar*           HScroll;

	  // methods:

	  virtual bool             _ShapeRectChanged   ();
     virtual bool             Reconfigure         (const UI_Rectangle&);
	  virtual bool             HandleChildEvent    (const UI_Event&);
	  virtual bool             KeyTyped            (char);
	  virtual bool             ButtonDown          (const UI_Point&,
																	UI_MouseButton,bool,bool);

};

#endif _iconwin_h_
