

// ##########################################################################
// #                                                                        #
// #                               NumberLabel                              #
// #                                                                        #
// #                            - Definitionen -                            #
// #                                                                        #
// ##########################################################################



#include"gui/numlabel.h"



// **************************************************************************
// *                             OBJEKT-HANDLING                            *
// **************************************************************************



// ************
// Konstruktion
// ************


NumberLabel :: NumberLabel(UI_VObjCollection*  parent,
									const UI_Rectangle& shape,
									UI_ViewID           id,
									unsigned            range,
									unsigned            pr,
									char                sep,
									bool                sgn
								  )
					  : UI_Label (parent, shape, id),
						 Cnv      (range,pr,sep,sgn)
{
  SetTextStyle(UIText_Right);
  initModel(0);
};




// ***********

// Destruktion
// ***********


NumberLabel :: ~NumberLabel()
{};


// ***************
// Attributzugriff
// ***************


StringConverter& NumberLabel :: cnv()
{
  return Cnv;
};



// **************************************************************************
// *                            MODEL-HANDLING                              *
// **************************************************************************



bool NumberLabel :: initModel(double x)
{
  bool      res = FALSE;
  CL_String s   = "";
  if (Cnv(x,s))
	{
	  res = TRUE;
	  ((CL_String&)(Model())) = s;
	};
  return res;
};


double NumberLabel :: asDouble()
{
  return Cnv.asDouble((CL_String&)(Model()));
};


long int NumberLabel :: asLong() 
{
  return Cnv.asLong((CL_String&)(Model()));
};
