

// ##########################################################################
// #                                                                        #
// #                             StringConverter                            #
// #                                                                        #
// #                            - Definitionen -                            #
// #                                                                        #
// ##########################################################################



#include"gui/strconv.h"
#include<stdio.h>


StringConverter StrConv(7,5,'.',TRUE);



// **************************************************************************
// *                             OBJEKT-HANDLING                            *
// **************************************************************************



// ************
// Konstruktion
// ************


StringConverter :: StringConverter(unsigned            range,
											  unsigned            pr,
											  char                sep,
											  bool                sgn
											 )
{
  Separator = sep;
  Precision = pr;
  Range     = range;
  Sign      = sgn;
};


// ***************
// Initialisierung
// ***************


void StringConverter :: initialize     (StringConverterDescriptor& d)
{
  Range     = d.Range;
  Precision = d.Precision;
  Sign      = d.Sign;
  Separator = d.Separator;
  return;
};


void StringConverter :: initialize (unsigned Rng,unsigned Prec,char Sep,bool Sg)
{

  Range     = Rng;
  Precision = Prec;
  Sign      = Sg;
  Separator = Sep;
  return;
};



// *************

// Konvertierung
// *************


bool StringConverter :: convert(double x, CL_String& s,
										  unsigned range,
										  unsigned prec,
										  char     sep,
										  bool     sgn
										 ) const
{
  bool res = FALSE;
  s = "";
  unsigned w   = range + prec + sgn + 1; // widht of string with termin.
  if (prec > 0)                          // one more for separator
	w++;
  char* tmp = new char[255];
  for (unsigned i=0; i<255; i++)
  tmp[i] = '\0';
  if (sprintf(tmp,"%*.*f",w,prec,x) != -1)
	  res = TRUE;
  s = tmp;
  if (sep != '.'  && prec > 0)     // replacement if necessary
	{
	  char* sep2 = " ";
	  sep2[0] = sep;
	  s.Replace(".",sep2);
	};
  delete [] tmp;
  return res;
};


bool StringConverter :: convert(double x, CL_String& s) const
{
  return convert(x,s,Range,Precision,Separator,Sign);
};


bool StringConverter :: convert(long x, CL_String& s,
										  unsigned range,
										  bool     sgn
										 ) const
{
  return convert(x,s,range,0,'.',sgn);
};


bool StringConverter :: convert (long x, CL_String& s,
											const StringConverterDescriptor& dsc
										  ) const
{
  return convert(x,s,dsc.Range,dsc.Precision,dsc.Separator,dsc.Sign);
};


bool StringConverter :: convert (long x, CL_String& s,
											const StringConverterDescriptor* dsc
										  ) const
{
  if (dsc)
		 return convert(x,s,dsc->Range,dsc->Precision,dsc->Separator,dsc->Sign);
  else return FALSE;
};


bool StringConverter :: operator()(double x, CL_String& s) const
{
  return convert(x,s);
};


bool StringConverter :: operator()(double x, CL_String& s,
											  unsigned range,
											  unsigned prec,
											  char     sep,
											  bool     sgn
											 ) const
{
  return convert(x,s,range,prec,sep,sgn);
};


bool StringConverter :: operator()(long x, CL_String& s,
											  unsigned range,
											  bool     sgn
											 ) const
{
  return convert(x,s,range,sgn);
};


bool StringConverter :: operator()(long x, CL_String& s,
											  unsigned range
											 ) const
{
  return convert(x,s,range);
};


bool StringConverter :: operator()(long x, CL_String& s,
											  const StringConverterDescriptor& dsc
											 ) const
{
  return convert(x,s,dsc);
};


bool StringConverter :: operator()(long x, CL_String& s,
											  const StringConverterDescriptor* dsc
											 ) const
{
  return convert(x,s,dsc);
};


double StringConverter :: asDouble(const char* cs) const
{
  CL_String s = cs;
  char * sep  = " ";
  sep[0] = Separator;
  s.Replace(sep,".");
  return s.AsDouble();
};


long int StringConverter :: asLong(const char* cs) const
{
  CL_String s = cs;
  char * sep  = " ";
  sep[0] = Separator;
  s.Replace(sep,".");
  return s.AsLong();
};


unsigned StringConverter :: size() const
{
  unsigned res = Range + Precision + Sign;
  if (Precision > 0)
		res++;
  return res;
};


// ****************
// Attributszugriff
// ****************


unsigned& StringConverter :: range     ()
{
  return Range;
};


unsigned& StringConverter :: precision ()
{
  return Precision;
};


bool&     StringConverter :: sign      ()
{
  return Sign;
};


char& StringConverter :: separator ()
{
  return Separator;
};


unsigned  StringConverter :: get_Precision () const
{
  return Precision;
};


bool      StringConverter :: get_Sign      () const
{
  return Sign;
};


char      StringConverter :: get_Separator () const
{
  return Separator;
};


bool      StringConverter :: sepByComma() const
{
  if (Separator == ',')
		 return TRUE;
  else return FALSE;
};


bool      StringConverter :: sepByPoint() const
{
  if (Separator == '.')
		 return TRUE;
  else return FALSE;
};


void StringConverter :: set_Range    (unsigned r)
{
  Range = r;
  return;
};


void StringConverter :: set_Precision(unsigned p)
{
  Precision = p;
  return;
};


void StringConverter :: set_Sign     (bool s)
{
  Sign = s;
  return;
};


void StringConverter :: set_Separator(char s)
{
  Separator = s;
  return;
};


void StringConverter :: set_Comma    ()
{
  Separator = ',';
  return;
};


void StringConverter :: set_Point    ()
{
  Separator = '.';
  return;
};



