
// ##########################################################################
// #                                                                        #
// #                             StringConverter                            #
// #                                                                        #
// #                            - Deklarationen -                           #
// #                                                                        #
// ##########################################################################


#ifndef _StringConverter_H
#define _StringConverter_H

#include"gui/strcnvds.h"
#include"base/string.h"


class StringConverter
{

  public:

	 StringConverter (unsigned            range  = 10,
							unsigned            pr     =  0,
							char                sep    = ',',
							bool                sgn    = FALSE
						  );



	 // conversion of a string:


	 double    asDouble  (const char*) const;
	 long int  asLong    (const char*) const;


	 // conversion of a CL_String given as parameter:

	 bool      convert   (double x, CL_String&)  const;
	 bool      operator()(double x, CL_String&)  const;
	 bool      convert   (double x, CL_String&,
								 unsigned range,
								 unsigned prec,
								 char     sep,
								 bool     sgn
								) const;
	 bool      operator()(double x, CL_String&,
								 unsigned range,
								 unsigned prec,
								 char     sep,
								 bool     sgn
								) const;
	 bool      convert   (long x, CL_String&,
								 unsigned range,
								 bool     sgn = FALSE
								) const;
	 bool      operator()(long x, CL_String&, unsigned range, bool sgn) const;
	 bool      operator()(long x, CL_String&, unsigned range) const;
	 bool      convert   (long x, CL_String&,

								 const StringConverterDescriptor&) const;

	 bool      convert   (long x, CL_String&,

								 const StringConverterDescriptor*) const;

	 bool      operator()(long x, CL_String&,

								 const StringConverterDescriptor&) const;

	 bool      operator()(long x, CL_String&,

								 const StringConverterDescriptor*) const;


	 // access to the attribute values:

	 void      initialize     (StringConverterDescriptor&);
	 void      initialize     (unsigned Rng, unsigned Prec, char Sep, bool Sgn);
	 unsigned& range          ();
	 unsigned& precision      ();
	 bool&     sign           ();
	 char&     separator      ();
	 bool      sepByComma     () const;
	 bool      sepByPoint     () const;
	 unsigned  get_Range      () const;
	 unsigned  get_Precision  () const;
	 bool      get_Sign       () const;
	 char      get_Separator  () const;
	 void      set_Range      (unsigned);
	 void      set_Precision  (unsigned);
	 void      set_Sign       (bool);
	 void      set_Comma      ();
	 void      set_Point      ();
	 void      set_Separator  (char);
	 unsigned  size           () const;


	protected:

	 char             Separator;
	 bool             Sign;
	 unsigned         Range;
	 unsigned         Precision;
};


extern StringConverter StrConv;


#endif _StringConverter_H
