

#include "gui/strdict.h"


StringDictionary :: StringDictionary ()
{
  Default = NULL;
}


long StringDictionary :: Add (const CL_String& o)
{
  return UI_StringSequence::Add(o);
}


long StringDictionary :: Add (const CL_String& o, void* k)
{
  Keys.Add(k);
  return UI_StringSequence::Add(o);
}


bool StringDictionary :: Insert (const CL_String& o, long i)
{
  return UI_StringSequence::Insert(o,i);
}


bool StringDictionary :: Insert (const CL_String& o, void* k, long i)
{
  Keys.Insert(k,i);
  return UI_StringSequence::Insert(o,i);
}



void* StringDictionary :: key (const char* c) const
{
  long idx = LinearSearch(c);
  if (idx >= 0)
		 return Keys[idx];
  else return NULL;
};


void*& StringDictionary :: key (const char* c)
{
  long idx = LinearSearch(c);
  if (idx >= 0)
		 return Keys[idx];
  else return Default;
};


const CL_Sequence<void*>& StringDictionary :: keys() const
{
  return Keys;
};


CL_Sequence<void*>& StringDictionary :: keys()
{
  return Keys;
};


CL_String StringDictionary :: Remove (long i)
{
  Keys.Remove(i);
  return UI_StringSequence::Remove(i);
};



CL_String StringDictionary :: ExtractLeftmost ()
{
  Keys.ExtractLeftmost();
  return UI_StringSequence::ExtractLeftmost();
}


CL_String StringDictionary :: ExtractRightmost ()
{
  Keys.ExtractRightmost();
  return UI_StringSequence::ExtractRightmost();
}


bool StringDictionary :: ShiftRightAt (long pos, long amount)
{
  Keys.ShiftRightAt(pos,amount);
  return UI_StringSequence::ShiftRightAt(pos,amount);
}


void StringDictionary :: operator= (const CL_Object& o)
{
  CL_Sequence<CL_String>::operator=(o);
  Keys.MakeEmpty();
  for (unsigned i=0; i<Size(); i++)
		Keys.Add(NULL);
  return;
};


StrSeq& StringDictionary :: operator= (const StrSeq& a)
{
  Keys.MakeEmpty();
  for (unsigned i=0; i<a.Size(); i++)
		Keys.Add(NULL);
  return CL_Sequence<CL_String>::operator=(a);
};


StringDictionary& StringDictionary :: operator= (const StringDictionary& d)
{
  if (&d != this)
	{
	  UI_StringSequence::operator=(d);
	  Keys = d.keys();
	};
  return *this;
};


StrSeq& StringDictionary :: operator+= (const StrSeq& a)
{
  for (unsigned i=0; i<a.Size(); i++)
		Keys.Add(NULL);
  return UI_StringSequence::operator+=(a);
};


StringDictionary& StringDictionary :: operator+= (const StringDictionary& a)
{
  Keys += a.keys();
  UI_StringSequence::operator+=(a);
  return *this;
};


long  StringDictionary :: Move (const CL_IntegerSet& s, StrSeq& toSeq)
{
  Keys.Remove(s);
  return UI_StringSequence::Move(s,toSeq);
};


long  StringDictionary :: Move (const CL_IntegerSet& s, StringDictionary& toSeq)
{
  Keys.Move(s,toSeq.keys());
  return UI_StringSequence::Move(s,toSeq);
};


void StringDictionary :: MakeEmpty ()
{
  Keys.MakeEmpty();
  UI_StringSequence::MakeEmpty();
};


bool StringDictionary :: ChangeSize (long new_size)
{
  Keys.ChangeSize(new_size);
  return UI_StringSequence::ChangeSize(new_size);
};


bool StringDictionary :: ShiftLeftAt (long pos, long amount)
{
  Keys.ShiftLeftAt(pos,amount);
  return UI_StringSequence::ShiftLeftAt(pos,amount);
}


bool StringDictionary :: IsSorted () const
{
  return FALSE;
};


bool StringDictionary :: Sort (long,long)
{
  return FALSE;
};


bool StringDictionary :: BinarySearch (const CL_String&, long&) const
{
  return FALSE;
}


long StringDictionary :: InsertByRank(const CL_String& o)
{
  long int idx = UI_StringSequence::InsertByRank(o);
  return idx;
}


long StringDictionary :: InsertByRank(const CL_String& o, void* v)
{
  long int idx = UI_StringSequence::InsertByRank(o);
  Keys.Insert(v,idx);
  return idx;
}
