
#
# ---------------- Control file for YACL make under SGI Delta C++ -------
#

# Define the widget set you want to compile YACL for:
# WIDGET_SET = x_yacl
WIDGET_SET = x_motif


#
# Various path names/libs: change as necessary, but only if your
# compiler or linker doesn't look for the C++, X and Motif libraries
# by default.
#

# Name of the platform. You can choose any name you like, but you
# probably want something close to your machine type.
YACLPLATFORM = sgi_delta_cc

# Directory under which the X11 include files live.
X11INC       = -I/usr/include/X11

# Directory under which the Motif include files live. Bear in mind
# that, if you set this directory to d, then the YACL source code will
# expect the Motif header files to be in the directory d/Xm.
# MOTIFINC     = -I/usr/include/X11


# Directory in which the X libraries live. 
# X11LIBPATH       = /usr/X11/lib

# Directory in which the Motif library lives.
MOTIFLIBPATH     = /usr/lib

# Some Unixes need libraries to be ranlib'ed in order to be
# usable. Others use ar with the ts flags. Others use neither.
RANLIB      = ar ts 


MOTIFLIBS    = -lXm -lXmu -lXt -lX11 


#
# ----------------- Should not need to change anything below --------------
# 

include $(YACLPATH)/control/$(WIDGET_SET).def


#
# Derived path names
#
YACLLIB      = $(YACLPATH)/lib/$(YACLPLATFORM)
YACLINC      = -I$(YACLPATH)


# Component names:

BASE         = base
IO           = io
MEMORY       = memory
UI           = ui

BASELIB      = $(YACLLIB)/lib$(BASE).a
IOLIB        = $(YACLLIB)/lib$(IO).a
MEMORYLIB    = $(YACLLIB)/lib$(MEMORY).a
UILIB        = $(YACLLIB)/lib$(UI).a

# Processors

CC          = CC
CCOMP       = cc

# Processor options:
# DEBUG    = -g

INCPATH  = $(YACLINC) $(CPP_INC)    $(X11INC)    $(WIDGET_INC)
LIBPATH  = $(X11LIB)  $(WIDGET_LIBPATH) -L$(YACLLIB)


CCOPTS      = $(PROFILE) $(OPTIMIZE) $(DEBUG) $(INCPATH) \
  -D$(WIDGET_SYMBOL) -c -D__UNIX__ -D__SGI_DELTA_CC__
LNKOPTS     = $(DEBUG) $(LIBPATH) $(PROFILE)
BASELNKLIB  = -l$(IO) -l$(BASE) -l$(MEMORY) -lm
UILNKLIB    = -l$(UI) $(BASELNKLIB) $(WIDGET_LIB)

