

#
# Control file for make under the EMX version of GNU C++. This control file
# allows the use of the gdb debugger.
#


# ---------------------- Configuration parameters -------------------------

# Change this to point to where emx lives:
EMXPATH = d:\emx\bin

# If you're using EMX 0.9a (gcc version 2.6.3) or earlier, set IOSTREAM to
# iostream. For EMX versions 0.9b (gcc version 2.7.2) and later, set
# IOSTREAM to stdcpp.

# IOSTREAM = iostream
IOSTREAM = stdcpp


# -------- Should not need to change anything below this line -------------





YACLPLATFORM = os2emx

# Path and file names for the class library components:


YACLLIB     = $(YACLPATH)/lib/$(YACLPLATFORM)
YACLINCLUDE = $(YACLPATH)


BASE     = base
IO       = io
MEMORY   = memory
UI       = ui
STATICS  = statics



BASELIB  = $(YACLLIB)\$(BASE).a
IOLIB    = $(YACLLIB)\$(IO).a
UILIB    = $(YACLLIB)\$(UI).a


#
# Processors
#
CC          = $(EMXPATH)\gcc
OMFAR       = $(EMXPATH)\emxomfar
AR          = $(EMXPATH)\ar


# Processor options:

# DEBUG       = -g
# OPTIMIZE    = -O2
INCLUDE = -I$(YACLINCLUDE) 
CCOPTS  = -c $(OPTIMIZE)  $(INCLUDE) $(DEBUG) -D__OS2__ -fno-implicit-templates
LNKOPTS = $(DEBUG)  -L$(YACLLIB)
LNKLIB      = -l$(UI) -l$(IO) -l$(BASE) -l$(MEMORY) -l$(IOSTREAM)
BASELNKLIB  = -l$(IO) -l$(BASE) -l$(MEMORY) -l$(IOSTREAM)
# LNKLIB  = -l$(UI) -l$(IO) -l$(BASE) -liostream

