

#
# Control file for make under the EMX version of GNU C++
#


# ---------------------- Configuration parameters -------------------------

# Change this to point to where emx lives:
EMXPATH = d:\emx\bin

# If you're using EMX 0.9a (gcc version 2.6.3) or earlier, set IOSTREAM to
# iostream. For EMX versions 0.9b (gcc version 2.7.2) and later, set
# IOSTREAM to stdcpp.

# IOSTREAM = iostream
IOSTREAM = stdcpp


# -------- Should not need to change anything below this line -------------





YACLPLATFORM = os2emx

# Path and file names for the class library components:


YACLLIB     = $(YACLPATH)/lib/$(YACLPLATFORM)
YACLINCLUDE = $(YACLPATH)


BASE     = base
IO       = io
MEMORY   = memory
UI       = ui
STATICS  = statics



BASELIB  = $(YACLLIB)\$(BASE).lib
IOLIB    = $(YACLLIB)\$(IO).lib
UILIB    = $(YACLLIB)\$(UI).lib


#
# Processors
#
CC          = $(EMXPATH)\gcc
OMFAR       = $(EMXPATH)\emxomfar
AR          = $(EMXPATH)\ar


# Processor options:

# DEBUG       = -g
# OPTIMIZE    = -O2
INCLUDE = -I$(YACLINCLUDE) 
CCOPTS  = -c $(OPTIMIZE)  $(INCLUDE) $(DEBUG) -D__OS2__ \
-fno-implicit-templates -Zomf -Zcrtdll
LNKOPTS = $(DEBUG) -Zomf -Zcrtdll -Zlinker /exepack:2 -Zlinker /BAS:0x10000 \
-Zlinker /A:4 -Zlinker /NOS -L$(YACLLIB)
# LNKOPTS = $(DEBUG) -Zomf -Zcrtdll -L$(YACLLIB)
LNKLIB      = -l$(UI) -l$(IO) -l$(BASE) -l$(MEMORY) -l$(IOSTREAM)
BASELNKLIB  = -l$(IO) -l$(BASE) -l$(MEMORY) -l$(IOSTREAM)
# LNKLIB  = -l$(UI) -l$(IO) -l$(BASE) -liostream

