


# -------------------------------------------------------------------------
#                 Control file for Watcom  C++ make                       |
#--------------------------------------------------------------------------



#
# ---------------------- Path names ----------------------------
#


!ifdef %WATCOM
WTCPATH      = $(%WATCOM)
!else
WTCPATH      = d:\WATCOM
!endif


#
# ------------------------- Preferences ------------------------
#

# If your Watcom C++ compiler is version 10.5 or later, uncomment this:
#
# WTC_10_5_OR_LATER = 1


# If you're building the DOS versions of the library, the default is to
# build in the flat memory model using the Watcom DOS extender. If you want to
# build for plain DOS without the extender, comment this out:

DOS386  = 1


# Do we want the 3d look using CTL3D? (Comment this out if you're compiling
# for Windows 95 or Windows NT 4.0.)
# USE_CTL3D    = -DUSE_CTL3D

# If you want a map file for your UI demo executables, uncomment the
# following:

# MAKE_MAPFILE = 1



# ------------- Should not need to change anything below this line --------


#
# ---------------------- What platform do we want? -------------
#

!ifdef %YACLPLATFORM
YACLPLATFORM = $(%YACLPLATFORM)
!else ifdef __NT__
YACLPLATFORM = WIN32
!else ifdef __OS2__
YACLPLATFORM = OS2
!else ifdef WINDOWS
YACLPLATFORM = WINDOWS
!else ifdef __MS_WINDOWS__
YACLPLATFORM = WINDOWS
!else ifdef DOS
YACLPLATFORM = DOS
!else ifdef MSDOS
YACLPLATFORM = DOS
!else
# By default, build for Windows
YACLPLATFORM = WINDOWS
!endif


# ---------------------- Command names and paths ---------------

!ifeq YACLPLATFORM WIN32
!ifdef WTC_10_5_OR_LATER
ZZ           = -zz
!endif

!ifdef __NT__
CC           = wpp386
CCOMP        = wcc386
LINK         = wlink
DEFINES      = -DWIN32 -D__MS_WIN32__ 
HDRPATH      = /i=$(WTCPATH)\h\nt
CTL3D        = ctl3d32
RC           = wrc.exe
RCFLAGS      =
!else
CC           = wpp386
CCOMP        = wcc386
LINK         = wlink
DEFINES      = -DWIN32 -D__MS_WIN32__ 
HDRPATH      = /i=$(WTCPATH)\h\nt
CTL3D        = ctl3d32
RC           = wrc.exe
RCFLAGS      =
!endif
!else ifeq YACLPLATFORM OS2
CC           = wpp386
CCOMP        = wcc386
LINK         = wlink
DEFINES      = -DOS2 -D__OS2__
HDRPATH      = /i=$(WTCPATH)\h\os2
# OTHERS       = /3s
!else ifeq YACLPLATFORM WINDOWS
# I can't use 32-bit windows because I have trouble linking ctl3d.
CC           = wpp
CCOMP        = wcc
LINK         = wlink
DEFINES      = -DWINDOWS -D__MS_WINDOWS__ 
HDRPATH      = /i=$(WTCPATH)\h\win
OTHERS       = /zWs/ml
CTL3D        = ctl3d
RC           = $(WTCPATH)\binb\wrc.exe
RCFLAGS      = -k -31
!else ifeq YACLPLATFORM DOS
!ifdef DOS386
CC           = wpp386
CCOMP        = wcc386
LINK         = wlink
OTHERS       = /mf
DEFINES      = -DDOS -D__MS_DOS__
!else
CC           = wpp
CCOMP        = wcc
LINK         = wlink
DEFINES      = -DDOS -D__MS_DOS__
!endif
!endif


!ifdef DEBUG
DEBUGFLAGS = -DDEBUG /d2
!endif




# ---------------------  Command names -------------------------
#

COPY    = copy
DELETE  = del
RENAME  = mv
SED     = sed
FIND    = find
AWK     = mawk
LIBR    = wlib
UNZIP   = unzip
ZIP     = zip
SH      = sh
MAKE    = wmake




YACLPATH    = $(%YACLPATH)
YACLLIB     = $(YACLPATH)\lib\$(YACLPLATFORM)
INCPATH     = /i=$(YACLPATH) /i=$(WTCPATH)\h
LIB         = $(YACLLIB)


#
# ---------------------- YACL components --------------------
#

BASE     = base
MEMORY   = memory
IO       = io
UI       = ui
BASELIB  = $(YACLLIB)\$(BASE).lib
IOLIB    = $(YACLLIB)\$(IO).lib
UILIB    = $(YACLLIB)\$(UI).lib



CCOPTS1 =  /bt=$(YACLPLATFORM) $(INCPATH) $(HDRPATH)
CCOPTS2 =  $(DEFINES) $(DEBUGFLAGS) $(OTHERS)
CCOPTS  =  $(CCOPTS1) $(CCOPTS2) $(ZZ) -zq


