

include $(YACLPATH)/control/emxos2.ctl


LIBS = base io ui


yacl: libdir $(LIBS)

everything: base io ui basedemo uidemos apps



libdir:
	-md $(YACLPATH)\lib
	-md $(YACLPATH)\lib\$(YACLPLATFORM)




.PHONY: base io ui uidemos

base:
	- cd base && make -f emxos2.mak && cd .. 


io:
	- cd io && make -f emxos2.mak && cd .. 


ui:
	- cd ui && make -f emxos2.mak && cd .. 


uidemos:
	- cd uidemo && make -f emxos2.mak && cd ..

apps:
	- cd apps/bmpview; make -f emxos2.mak ; cd ../dlged
	- make -f emxos2.mak; cd ../..
        

clean:
	-rm -f base/*.obj io/*.obj ui/*.obj
	-rm -f lib/$(YACLPLATFORM)/base.lib lib/$(YACLPLATFORM)/io.lib
	-rm -f lib/$(YACLPLATFORM)/ui.lib
	-rm -f apps/dlged/*.obj apps/dlged/*.exe
	-rm -f apps/bmpview/*.obj apps/bmpview/*.exe
#	-cd uidemo && make -f emxos2.mak clean && cd ..
        

        



ZIP = zip

zip:
	-del yacl_all.zip
	find . -type f |  egrep -v \
        "\.(tr2|td2|ilk|pdb|dbg|lnk|ini|tr2|trw|tdw|td|log|lib|zip|bak|obj|exe|map|res|rws|vcp)$" | sort -u  | $(ZIP) yacl_all.zip -@

changezip:
	rm -f changes.zip
	find . -newer watmak.ctl \! \( -perm +u+x \) -print | \
        egrep -v '\.[oa]' | sort  | \
	$(ZIP) changes.zip -@

uizip:
	rm -f yaclui.zip
	(find ./ui ./uidemo \! \( -perm +u+x -o -name '*.o' -o -name \
        '*.a' \)  -print; ls ./*.ctl ./makefile.* ./changlog ./*.txt)| sort | \
	$(ZIP) yaclui.zip -@


