

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma implementation
#endif



#if defined(__BORLANDC__) || defined(_MSC_VER) || defined(__WATCOMC__) || \
    defined(__IBMCPP__)
#include <io.h>
#    if defined(__BORLANDC__)
#    pragma warn -ncf
#    endif
#endif

#if defined(__GNUC__)
#    if __GNUC_MINOR__ >= 7
#        include <string.h>
#    endif
extern "C" {
#    include <unistd.h>
#endif
#include <fcntl.h>
#if defined(__OS2__)  // The EMX version of GCC
#    include <sys/types.h>
#    include <io.h>
#endif
#if __GNUC_MINOR <= 6
#    include <string.h>
#endif
#include <sys/stat.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#ifdef __GNUC__
}
#else  /* Not GNUC */
#    ifdef __UNIX__
#    include <sys/stat.h>
#    include <errno.h>
#    include <stdio.h>
#    include <stdlib.h>
#    include <stdarg.h>
#    include <unistd.h>
#    endif
#endif

#if defined(__DEC_ULTRIX__)
extern "C" int ftruncate (int, int);
#endif

// #ifdef WINDOWS
// #include <windows.h>
// #endif
 
#include "io/binfile.h"

#include "base/error.h"
 

CL_BinaryFile::CL_BinaryFile (const char *pathname, ushort flags)
: _pathName (pathname), _flags (flags)
{
    struct stat st_buf;

    _fd = -1;
    if ((flags & CLFile_Create) && !Create (_pathName)) {
        _MakeErrorString ("BinaryFile constructor: create failed");
        return;
    }
    else if (! Exists (_pathName, flags)) {
        _MakeErrorString ("BinaryFile constructor: file does not exist");
        return;
    }

    if (stat (_pathName, &st_buf) < 0)  {
        _MakeErrorString ("BinaryFile constructor: stat failed");
        return;
    }
    // #ifndef MS_WINDOWS
    _Open ();
    // #endif
} 
 
 
CL_BinaryFile::~CL_BinaryFile()
{
    _Close();
}
 
 
 
bool CL_BinaryFile::Create (const char* pathName)
{
    int fd;

    // #ifndef MS_WINDOWS
    if ((fd = creat (pathName, S_IREAD|S_IWRITE)) <= 0) {
        return FALSE;
    }
    close (fd);
// #else
//     OFSTRUCT    OfStruct;
//  
//     int mode =   OF_READWRITE | OF_CREATE;   //This will truncate the file
//     fd = OpenFile (_pathName, &OfStruct, mode);
//     _lclose (fd);
// #endif
    return TRUE;
}
 

long CL_BinaryFile::Size () const
{
// #ifdef __BORLANDC__
    long current = lseek (_fd, 0L, SEEK_CUR);
    if (current == -1)
        return -1;
    long size = lseek  (_fd, 0L, SEEK_END);
    if (size == -1)
        return -1;
    lseek (_fd, current, SEEK_SET);
    return size;
// #else
//     struct stat st_buf;
//     _MakeErrorString ("");
//     if (stat (_pathName, &st_buf) < 0)  {
//         _MakeErrorString ("Size: stat failed");
//         return -1;
//     }
//     unsigned long fileSize =  st_buf.st_size;
//     return fileSize;
// #endif
}
 

#if defined(__UNIX__)
#define CHANGESIZE ftruncate
#elif defined(__DOS__) || defined(__OS2__) || defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#define CHANGESIZE chsize
#endif

bool CL_BinaryFile::ChangeSize (long size)
{
    if (!PrepareToChange())
        return FALSE;
// #ifdef MS_WINDOWS
//     Open ();
// #endif
    _MakeErrorString ("");
    
    if (CHANGESIZE (_fd, size) == -1) {
        _MakeErrorString ("BinaryFile::ChangeSize: chsize  call failed");
        return FALSE;
    }
// #ifdef MS_WINDOWS
//     Close();
// #endif
    Notify ();
    return TRUE;
}

 
 
long CL_BinaryFile::Read (uchar *buffer, long num_bytes)  const
{
    int	nn;

    _MakeErrorString ("");
// #ifdef MS_WINDOWS
//     Open();
// #endif
    
    // #ifndef MS_WINDOWS
    if ((nn = read (_fd, buffer, num_bytes)) < 0) {
// #else
//     if ((nn = _lread (fd, buffer, num_bytes)) < 0) {
// #endif
        _MakeErrorString ("BinaryFile::Read: read call failed");
    }
// #ifdef MS_WINDOWS
//     Close();
// #endif
    return nn;
}
 


    
 
bool CL_BinaryFile::Write (uchar *buffer, long num_bytes)
{

// #ifdef MS_WINDOWS
//     Open();
// #endif

    if (!(_flags & CLFile_Write) || !PrepareToChange())
        return FALSE;
    _MakeErrorString ("");
    // #ifndef MS_WINDOWS
    if ((write (_fd, buffer, num_bytes)) < 0) {
        _MakeErrorString ("BinaryFile::Write: write call failed");
        return FALSE;
    }
// #else
//     if ((_lwrite (fd, buffer, num_bytes)) < 0) {
//         CL_Error::Fatal ("CL_BinaryFile::Write: write failed: %s",
//             strerror (errno));
//     }
// #endif
// #ifdef MS_WINDOWS
//     Close();
// #endif
    Notify ();
    return TRUE;

}
 
 


bool CL_BinaryFile::SeekTo (long position) const
{
    _MakeErrorString ("");
// #ifdef MS_WINDOWS
//     if ((retval = _llseek (fd, position, SEEK_SET)) < 0) {
// #else
    if (lseek (_fd, position, SEEK_SET) == -1L) {
        // #endif
        _MakeErrorString ("BinaryFile::SeekTo: lseek call failed");
        return FALSE;
    }
    return TRUE;
}
 

bool CL_BinaryFile::SeekRelative (long position) const
{
    _MakeErrorString ("");
// #ifdef MS_WINDOWS
//     if ((retval = _llseek (fd, position, SEEK_CUR)) < 0) {
// #else
    if (lseek (_fd, position, SEEK_CUR) == -1L) {
// #endif
        _MakeErrorString ("BinaryFile::SeekRelative: lseek call failed");
        return FALSE;
    }
    return TRUE;
}
 

bool CL_BinaryFile::Eof () const
{
#if defined(__UNIX__)
    long current = lseek (_fd, 0L, SEEK_CUR);
    if (current == -1)
        return TRUE;
    long size = lseek  (_fd, 0L, SEEK_END);
    if (size == -1)
        return TRUE;
    lseek (_fd, current, SEEK_SET);
    return size == current;
#elif defined(__DOS__) || defined(__OS2__) || defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return eof (_fd);
#endif
}


long CL_BinaryFile::Offset () const
{
    return lseek (_fd, 0, SEEK_CUR);
}

 
bool CL_BinaryFile::Exists (const char *pathname, ulong accessPerms)
{
#if defined(__BORLANDC__) || defined(_MSC_VER) || defined(__IBMCPP__)
    // Borland C, IBM C and Microsoft C do not define these symbols.
    const int R_OK = 0x04;
    const int W_OK = 0x02;
#endif
    int mode = 0;
    if (accessPerms & CLFile_Read)
        mode |= R_OK;
    if (accessPerms & CLFile_Write)
        mode |= W_OK;
    return (access (pathname, mode) == 0);
}  
 
 
 

// Protected methods
 
bool CL_BinaryFile::_Open()
{
    _MakeErrorString ("");
    // #ifndef MS_WINDOWS
    int mode = O_RDWR;
    int flag = 0;
    if ((_flags & CLFile_Read) && (_flags & CLFile_Write))
        mode = O_RDWR;
    else if (_flags & CLFile_Read)
        mode = O_RDONLY;
    else if (_flags & CLFile_Write)
        mode = O_WRONLY;
    else {
        CL_String err;
        err.AssignWithFormat ("BinaryFile constructor: invalid "
                              " flags parameter 0x%04x", _flags);
        _MakeErrorString (err.AsPtr());
        return FALSE;
    }
    
    if (_flags & CLFile_Read)
        flag |= S_IREAD;
    if (_flags & CLFile_Write)
        flag |= S_IWRITE;
    
#if defined(__DOS__) || defined(__MS_WINDOWS__) || defined(__OS2__) || defined(__MS_WIN32__)
    mode |= O_BINARY;
#endif
    _fd = open (_pathName.AsPtr(), mode, flag);
// #else
//     OFSTRUCT    OfStruct;
// 
//     int mode =   OF_READWRITE;
//     fd = OpenFile (_pathName.AsPtr(), &OfStruct, mode);
// #endif
    if (_fd < 0) 
        _MakeErrorString ("BinaryFile::_Open: open call failed");
    return (_fd >= 0);
}
 
 
void CL_BinaryFile::_Close()
{

    if (_fd < 0)
        return;
// #ifndef MS_WINDOWS
    close (_fd);
// #else
//     _lclose (fd);
// #endif
    _fd = -1;
}




bool CL_BinaryFile::SeekToEnd () const
{
    long retval;

    _MakeErrorString ("");
// #ifdef MS_WINDOWS
//     if ((retval = _llseek (fd, 0L, SEEK_END)) < 0) {
// #else
    if ((retval = lseek (_fd, 0L, SEEK_END)) < 0) {
// #endif
        _MakeErrorString  ("BinaryFile::SeekToEnd: seek call failed");
    }
    return retval >= 0;
}


CL_String CL_BinaryFile::AsString () const
{
    return _pathName;
}


CL_String CL_BinaryFile::ErrorString() const
{
    return _errorString;
}




void CL_BinaryFile::_MakeErrorString (const char* msg) const
{
    if (CL_String (msg).Length() > 0) {
        ((CL_BinaryFile*) this)->_errorString.AssignWithFormat
            ("File '%s': %s: %s", _pathName.AsPtr(), msg, strerror (errno));
        // Cast away const
        // CL_Error::Warning (_errorString);
    }
    else
        ((CL_BinaryFile*) this)->_errorString = "";
}


#ifdef __BORLANDC__
#pragma warn .ncf
#endif
