
#
# makefile for cfront generated io library
#

#
# See base/cfr_sun.mak for detail explanation of the format and whys
# for this makefile.  It mimics that one.
#

include $(YACLPATH)/control/cfr_sun.ctl

PTREP = $(PTALL)

IOILIST=ioilist
IOLIB = $(YACLLIB)/lib$(IO).a
IOOBJS =    \
	binfile.o     \
	bytstore.o \
        directry.o \
	dskbtree.o \
        pathname.o \
	slotfile.o

LIBRARIES=$(IOLIB)

all: $(IOLIB) 
	@echo IO Library Contents
	@ar ts $(IOLIB)

$(IOLIB): $(IOILIST)
	ar rucv $(IOLIB) $(IOOBJS) `cat $(IOILIST)
	@$(RANLIB) $(IOLIB) > /dev/null

#
# Note we need to add BASELIB to the command which instantiates the
# templates.  This is because the template instantiation mechanism
# keeps going until all unresolved references are instantiated.  Since
# there are references to stuff in BASELIB (namely the static objects)
# we need to provide these to the CC command.
#
$(IOILIST): $(IOOBJS)
	rm -f $(IOILIST)
	$(CC) $(PTDUMP)$(IOILIST) $(LNKOPTS) $(IOOBJS) -l$(BASE)
	if [ ! -r $(IOILIST) ]; then cat /dev/null > $(IOILIST); fi

CLEANFILES = \
	$(IOILIST)

