

/*
 *
 *          Copyright (C) 1996, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1996. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

#include <ctype.h>
#if defined(__WATCOMC__) || defined(_MSC_VER)
#    include <direct.h>
#elif defined(__UNIX__)
#    include <unistd.h>
#elif defined(__OS2__) && defined(__GNUC__)  // EMX compiler
#    include <unistd.h>
#    include <sys/types.h>
#else
#    include <dir.h>
#endif

#if !defined(__WATCOMC__) && !defined(_MSC_VER)
#    include <dirent.h>
#endif

#include <sys/stat.h>

#include "io/directry.h"


static bool IsRelative (const char* path)
{
#if defined(__UNIX__)
    return path && path[0] != '/';
#else // DOS, OS/2 and their ilk
    return path && (path[0] != '\\' &&
                    ! (isalpha(path[0]) && path[1] == ':'));
#endif
}

CL_Directory::CL_Directory (const char* path)
: _pathName (path)
{
    if (IsRelative (path)) {
        char* path = getcwd (NULL, 0);
        _fullPathName = CL_String (path) + PathSeparator();
    }
    _fullPathName += path;

    _valid = IsDirectory (path);
}


bool CL_Directory::IsDirectory (const char* path)
{
    struct stat statbuf;
    if (stat (path, &statbuf) == 0)
        return statbuf.st_mode & S_IFDIR ? TRUE : FALSE;
    else
        return FALSE;
}



CL_StringSequence CL_Directory::FileNames () const
{
    CL_StringSequence sq;
    if (!_valid)
        return sq;
    DIR* dir;
    struct dirent* ent;
    if ((dir = opendir (_pathName)) == NULL)
        return sq; // Failed
    while ((ent = readdir (dir)) != NULL)
        sq.Add (ent->d_name);
    closedir (dir);
    return sq;    
}
