

#ifndef _directry_h_ /* Tue Apr 30 09:30:09 1996 */
#define _directry_h_


/*
 *
 *          Copyright (C) 1996, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1996. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

// This is an encapsulation of a directory. It is NOT supported under
// Microsoft Visual C++ or IBM Visual Age C++, because those compilers do
// not provide the necessary POSIX compatibility.


#include "io/iodefs.h"  // Include this first!!!

#include "base/strgseq.h"


class YACL_IO CL_Directory {

public:
    CL_Directory (const char* pathName = ".");
    // Create a directory object for the given path name. The parameter may
    // be an absolute or relative path name.


    bool IsValid () const {return _valid;};
    // Is this a valid directory?

    CL_String PathName () const {return _pathName;};
    // Return the path name used when this Directory object was created.
    
    CL_String FullPathName () const { return _fullPathName;};
    // Return the full absolute path name of this directory.
    
    CL_StringSequence FileNames () const;
    // Return a StringSequence containing the names of the files in this
    // directory. The disk structure is re-read on each call to this method.
    // The contents of the sequence are in the order of occurrence of the
    // entries in the disk directory (i.e., they are not necessarily
    // sorted by file name).
    
    inline static const char* PathSeparator ();
    // Return a null-terminated string of length 1, containing the character
    // used on the platform operating system for separating directory names
    // in a full path spec. Under Unix, this method returns the forward
    // slash, while under DOS, Windows and OS/2 it returns the backslash.

    static bool IsDirectory (const char* path);
    // Return TRUE if the given path specifies a directory, and FALSE
    // otherwise.
    
protected:
    CL_String _pathName;
    CL_String _fullPathName;
    bool      _valid;
    
};



#if defined(__UNIX__)
inline const char* CL_Directory::PathSeparator()
{
    return "/";
}
#elif defined(__OS2__) || defined(__DOS__) || defined(__MS_WINDOWS__) \
       || defined(__MS_WIN32__)
inline const char* CL_Directory::PathSeparator()
{
    return "\\";
}
#endif



#endif /* _directry_h_ */
