


/*
 *
 *          Copyright (C) 1996, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1996. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#include "io/pathname.h"


#if defined(__MS_DOS__) || defined(__MS_WINDOWS__) || defined(__MS_WIN32__) \
 || defined(__OS2__)
const char CL_PathName::Separator = '\\';
#elif defined(__UNIX__)
const char CL_PathName::Separator = '/';
#endif



CL_PathName::CL_PathName (const char* path)
: _pathName (path)
{
}

CL_PathName::CL_PathName (const CL_PathName& p)
: _pathName (p._pathName.AsPtr())
{
}

CL_String CL_PathName::DirectoryName () const
{
    long l = _RightmostSeparatorPos();
    if (l < 0)
        return ".";
    return _pathName (0, l-1);
}


CL_String CL_PathName::FileName () const
{
    return _pathName.Suffix(_RightmostSeparatorPos());
}


long CL_PathName::_RightmostSeparatorPos () const
{
    const char* p = _pathName.AsPtr();
    long l = _pathName.Size();
    long i;
#if defined(__UNIX__)
    for (i = l-1; i >= 0; i--)
        if (p[i] == Separator)
            break;
    return i;
#elif defined(__DOS__) || defined(__MS_DOS__) || defined(__MS_WINDOWS__)\
    || defined(__MS_WIN32__) || defined(__OS2__)
    for (i = l-1; i >= 0; i--)
        if (p[i] == '/' || p[i] == '\\')
            break;
    return i;
#endif    
}

// CL_String CL_PathName::AbsolutePathName () const
// // Return the absolute path name of this path.
// {
// }



