


#/*
# *
# *          Copyright (C) 1994, M. A. Sridhar
# *  
# *
# *     This software is Copyright M. A. Sridhar, 1994. You are free
# *     to copy, modify or distribute this software  as you see fit,
# *     and to use  it  for  any  purpose, provided   this copyright
# *     notice and the following   disclaimer are included  with all
# *     copies.
# *
# *                        DISCLAIMER
# *
# *     The author makes no warranties, either expressed or implied,
# *     with respect  to  this  software, its  quality, performance,
# *     merchantability, or fitness for any particular purpose. This
# *     software is distributed  AS IS.  The  user of this  software
# *     assumes all risks  as to its quality  and performance. In no
# *     event shall the author be liable for any direct, indirect or
# *     consequential damages, even if the  author has been  advised
# *     as to the possibility of such damages.
# *
# */




#
# An awk script for reading a .RC file (output from a resource editor)
# and creating a C file containing a series of initializations of
# an array of UI_ViewDescriptor structures. 
#
# Invoke with:
#
#        awk -f winbuild.awk incl=includefilename rcfilename
#
# where includefilename is the name of the file containing symbol
# definitions for the RC file, without surrounding quotes.
#
# When translating button groups, this script assumes that:
#    * The GROUPBOX is specified first, with attribute WS_GROUP but
#      not WS_TABSTOP
#    * All the buttons in the group follow, with the first button in
#      the group having a WS_TABSTOP attribute set. No other buttons in
#      the group must have WS_TABSTOP set.
# This arrangement ensures proper tabbing behavior of the dialog.
#    Also, the input RC file must have CONTROL statements for all
# controls (set this option in the Resource Editor's Options menu).
#

BEGIN {
    n = split(ARGV[1], a, "=")
    HeaderFile = a[2]       # Name of file containing definitions of
                            # dialog symbols
    print " "
    print "/* C++ code file for creating control objects, generated via */"
    print "/* AWK script translat.awk. Must be used with the UI_Composite */"
    print "/* class. */ "
    print  "\n\n#include \"ui/composit.h\"\n"
    if (length(HeaderFile) > 0) printf "#include \"%s\"\n\n", HeaderFile
    # We need to scale the sizes:
    XFactor = 2.5
    YFactor = 2.2
}




# {printf "%d: ", NR } # DEBUG

#
# Process include directives
#
/^# *include/ {print; next}


#
# Target 0: look for the DIALOG specification
#
{ 
    if ($2 == "DIALOG") {
        dialog_name = $1
        rectn  = split($0, array, ", ")
        dialog_shape = XFactor*$(NF-3) ", " YFactor*$(NF-2) ", " 
        dialog_shape = dialog_shape XFactor*$(NF-1) ", " YFactor*$NF
        next
    }
}

#
# Target 1: match the BEGIN that starts a dialog spec
#
$1 ~ /BEGIN/        {
    nBtnGroups = 0
    if (length (dialog_name) > 0) {
        # So that we don't process things inside menus
        inside = 1   # We're now processing a dialog
        inGroup = 0
        dialogDesc = ""
        ncontrols = 0

        map["LISTBOX"]       = "View_StringViewSingle"
        map["EDITTEXT"]      = "View_StringEditor"
        map["STATIC"]        = "View_Label"
        map["LTEXT"]         = "View_Label"
        map["RTEXT"]         = "View_Label"
        map["CTEXT"]         = "View_Label"
        map["PUSHBUTTON"]    = "View_PushButton"
        map["DEFPUSHBUTTON"] = "View_PushButton"
        map["RADIOBUTTON"]   = "View_ExOrToggleButton"
        map["CHECKBOX"]      = "View_ToggleButton"
        map["SCROLLBAR"]     = "View_ScrollBar"
        map["GROUPBOX"]      = "View_ButtonGroup"

        next
    }

}

$1 ~ /END/        {
    if (length (dialog_name) > 0) {
        for (s in buttonGroup) {
            print "UI_ViewDescriptor FAR DLG_" dialog_name "_group" s "[] = {"
            printf "%s",  buttonGroup[s]
            print "{View_None, 0, 0}\n};\n\n"
            delete buttonGroup[s]
        }
              
        print "UI_RectangleStruct FAR  DLG_" dialog_name "_Shape = {"
        print dialog_shape "\n};"
        print "UI_ViewDescriptor FAR DLG_" dialog_name "_Item [] = {" 
        printf "%s", dialogDesc
        print "View_None, 0, 0\n}; \n"
        inside = 0
        dialog_name = ""
        next
    }
}
        
#
# Other targets: process the control statements
#
# 
$1 ~ /LTEXT|CTEXT|RTEXT|CHECKBOX|PUSHBUTTON|RADIOBUTTON/   {
    if (inside) {
        # pos = match ($0, $1)
        # m = RSTART + RLENGTH - 1
        # print $1 ", " substr($0,m+1,length($0)-m) ", 0,"

        # Extract the type of control and its id number
        nfields = split ($0, fld, ",")
        nf = split (fld[1], f2, " ")
        tabstop = ($1 ~ /TEXT/) ? "FALSE" : "TRUE"
        AddEntry(map[$1], fld[2], fld[3], fld[4], fld[5], fld[6], tabstop,
                   "TRUE",  f2[2], "NULL")
        next
    }
}

$1 ~ /LISTBOX|EDITTEXT|SCROLLBAR/ {
        nfields = split ($0, fld, ",")
        nf = split (fld[1], f2, " ")
        tabstop = ($1 ~ /SCROLLBAR/) ? "FALSE" : "TRUE"
        ctrlType = map[f2[1]]
        if ($1 ~ /LISTBOX/ && fld[5] ~ /LBS_MULTIPLESEL/) \
             ctrlType = "View_StringViewMultiple"
        AddEntry(ctrlType, f2[2], fld[2], fld[3], 
                   tabstop, "TRUE", fld[4], fld[5], "NULL")
        next
}


$1 ~ /CONTROL/    {
    if (inside) {
        nfields = split ($0, fld, ",")
        label = fld[3]
        gsub (/"/, "", label)
        gsub (/ /, "", label)
        if (label ~ /EDIT/) label = "EDITTEXT"
        if (fld[4] ~ /RADIOBUTTON/) label = "RADIOBUTTON"
        if (fld[4] ~ /CHECKBOX/) label = "CHECKBOX"
        if (fld[4] ~ /PUSHBUTTON/) label = "PUSHBUTTON"
        if (label  ~ /BorCheck/) label = "CHECKBOX"
        if (label  ~ /BorRadio/) label = "RADIOBUTTON"
        if (label  ~ /BorShade/) label = "GROUPBOX"
        if (label == "button") label = "BUTTON"
        if (label != "RADIOBUTTON" && label !=  "CHECKBOX") {
            inGroup = 0
        }
        if (fld[4] ~ /GROUPBOX/) {
            label = "GROUPBOX"
        }
        if (label in map) {
            n = split (fld[1], f2, "\"")
            tabstop = (fld[4] ~ /TABSTOP/) ? "TRUE" : "FALSE"
            visible = (fld[4] ~ /VISIBLE/) ? "TRUE" : "FALSE"
            if (label == "GROUPBOX") {
                children = "DLG_" dialog_name "_group" nBtnGroups+1
            }
            else children =  "NULL"
            AddEntry(map[label], fld[2], fld[5], fld[6],
                        fld[7], fld[8], tabstop, visible, f2[2], children)
        } else {
           print "Warning: Line " NR ": unrecognized control: " label
        }
        if (label == "GROUPBOX") {
            nBtnGroups++
            groupX = fld[5]
            groupY = fld[6]
            inGroup = 1
        }
        next
    }
}

                

function AddEntry(type, id, x, y, w, h, tabst, vis, title, enclosed       ,s) {
    gsub(/"/, "", title)
    entryFmt = "{%-16s, %-10s, %4d, %4d, %4d, %4d, %-5s,  \"%s\", %s},\n"
    if (inGroup) {
        s = sprintf(entryFmt, type, id, XFactor*(x-groupX), YFactor*(y-groupY),
                    XFactor*w, YFactor*h, tabst,  title, enclosed)
        s = buttonGroup[nBtnGroups] s
        buttonGroup[nBtnGroups] = s
    }
    else {
        s = sprintf(entryFmt, type, id, XFactor*x, YFactor*y,
                    XFactor*w, YFactor*h, tabst,  title, enclosed)
        dialogDesc = dialogDesc s
    }
}

