

#ifndef _3dlabel_h_ /* Mon Dec 25 17:15:55 1995 */
#define _3dlabel_h_




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


// A 3DLabel is a label drawn with a 3-d look, either raised, recessed
// or embossed.
//
// Caveat: a raised or recessed 3DLabel must be at least 12 pixels tall, and
// an embossed one must be at least 16 pixels tall.
//
// The implementation of this object does not use a separate window.
// Instead, it hooks paint events destined for its parent, and draws itself
// if necessary. This is important in case you create a 3dlabel object as a
// child of some other object v, and then draw on v. Also worth noting is
// the fact that the entire 3dlabel code uses only YACL facilities and does
// not make direct calls to the native platform.
//
// Caveat: Don't create too many of these objects. Each one uses an
// in-memory display surface, which can be an expensive resource for a
// typical windowing system.


#include "ui/label.h"

class YACL_UI UI_DisplaySurface;
class YACL_UI UI_DwgSurfaceInMemory;
class YACL_UI UI_Bitmap;

class YACL_UI UI_3DLabel: public UI_Label {

public:
    enum LabelStyle { Plain, Raised, Recessed, Embossed };
    
    UI_3DLabel (UI_VisualObject* parent, 
                const UI_Rectangle& r, UI_ViewID id,
                LabelStyle style = Recessed, short shadowThickness = 1);
    // Constructor: use this object's own model. The model will be
    // destroyed when this object is destroyed.

    UI_3DLabel (UI_VisualObject* parent, CL_String* model,
                const UI_Rectangle& r, UI_ViewID id,
                LabelStyle style = Recessed);
    // Constructor: use the given string (second parameter) as model. The
    // model string is viewed as ``borrowed'', so it
    // is not this object's responsibility to destroy the model.

    UI_WindowClass WindowClass () const;
    
    const char* ClassName () const {return "UI_3DLabel";};
    
protected:
    bool MakeVisualElement ();

    bool DestroyVisualElement ();

    bool _PaintEvent (UI_Event&);

    void MakeVisible ();

    void MakeInvisible ();
    
    void _DoPaint (UI_DrawingSurface&);

    bool _TitleChanged();

    bool _ShapeRectChanged();

    void _DrawText (UI_DrawingSurface&);

    bool _DoShowBorder (bool);

    void _Redraw ();

    short _EmbossWidth () const;

    void  _RebuildBitmap ();
    
    LabelStyle _style;
    short      _shadowThickness;
    //--    UI_DwgSurfaceInMemory* _memDS;
    UI_Bitmap* _bMap;
    
};

#endif /* _3dlabel_h_ */

