





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#include "base/defs.h"

#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
#    define OEMRESOURCE
#    if defined(_MSC_VER)
#        include <memory.h>
#    else
#        include <mem.h>
#    endif
#    include <stdio.h>
#    include <windows.h>
     extern "C" {
#    include "ui/support/windows/dibutil.h"   // Courtesy MSDN
#    include "ui/support/windows/dibapi.h"    // Courtesy MSDN
     }
#elif defined (__OS2__)
#    if defined(__GNUC__) || defined(__IBMCPP__)
#        include <memory.h>
#    else
#        include <mem.h>
#    endif
#    include <stdio.h>
#elif defined (__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <X11/Intrinsic.h>
#    include <iostream.h> // DEBUG
#    include <malloc.h>
#elif defined(__X_YACL__)
#    include <malloc.h>
#    include <X11/Intrinsic.h>
#endif



#include "base/string.h"
#include "base/map.h"
#include "base/bytstrng.h"
#include "io/binfile.h"

#include "ui/bitmap.h"
#include "ui/cntroler.h"
#include "ui/dsplsurf.h"
#include "ui/color.h"



struct BitmapFileHeader {
    uchar  type[2];
    uchar  size[4];
    ushort reserved[2];
    uchar offset[4];
};


struct BitmapInfoHeader {
    ulong  size;
    uchar  width[4];
    uchar  height[4];
    ushort planes;
    uchar  bcount[2];
    ulong  compression;
    ulong  bsize;
    ulong  hres;
    ulong  vres;
    ulong  ncolors;
    ulong  nicolors;
};


struct RGBQuad {
    uchar blue;
    uchar green;
    uchar red;
    uchar res;
    void operator= (const UI_BitmapData::ColorInfo& info)
        {blue = info.blue; red = info.red; green = info.green;};
};

static const short BITS_PER_BYTE = 8;

inline ulong _MakeLong (uchar data[4])
{
    long d = (long) data [3];
    long c = (long) data [2];
    long b = (long) data [1];
    long a = (long) data [0];

    return ((d << 24) | (c << 16) | (b << 8) | (a));
}


inline ulong _MakeShort (uchar data[2])
{
    long b = (long) data [1];
    long a = (long) data [0];

    return ((b << 16) | (a));
}





#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
static struct {
    char* name;
    long  code;
} BuiltIn [] = {
"+OBM_CLOSE"   , OBM_CLOSE   ,
"+OBM_UPARROW" , OBM_UPARROW ,
"+OBM_DNARROW" , OBM_DNARROW ,
"+OBM_RGARROW" , OBM_RGARROW ,
"+OBM_LFARROW" , OBM_LFARROW ,
"+OBM_REDUCE"  , OBM_REDUCE  ,
"+OBM_ZOOM"    , OBM_ZOOM    ,
"+OBM_RESTORE" , OBM_RESTORE ,
"+OBM_REDUCED" , OBM_REDUCED ,
"+OBM_ZOOMD"   , OBM_ZOOMD   ,
"+OBM_RESTORED", OBM_RESTORED,
"+OBM_UPARROWD", OBM_UPARROWD,
"+OBM_DNARROWD", OBM_DNARROWD,
"+OBM_RGARROWD", OBM_RGARROWD,
"+OBM_LFARROWD", OBM_LFARROWD,
"+OBM_MNARROW" , OBM_MNARROW ,
"+OBM_COMBO"   , OBM_COMBO   ,
"+OBM_UPARROWI", OBM_UPARROWI,
"+OBM_DNARROWI", OBM_DNARROWI,
"+OBM_RGARROWI", OBM_RGARROWI,
"+OBM_LFARROWI", OBM_LFARROWI,
0, 0
};

#endif



static ushort _BytesPerRow (ushort nColumns, ushort nColorBits)
{
    // Return the number of bytes in each row of the Windows bitmap
    ushort bitsInRow  = nColumns * (short) nColorBits;
    ushort bytesInRow = bitsInRow/8 + (bitsInRow % 8 ? 1 : 0);
    // Round up to multiple of 4
    ushort leftOver   = bytesInRow % 4;
    if (leftOver)
        bytesInRow += 4 - leftOver;
    return bytesInRow;
}

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
// Sridhar Aug 2, 1995:
DWORD FAR DIBImageSize (LPSTR lpDIB)
{
    LPBITMAPINFOHEADER lpbmi;  // pointer to a Win 3.0-style DIB
    
    /* point to the header (whether Win 3.0 and OS/2) */
    
    lpbmi = (LPBITMAPINFOHEADER)lpDIB;
    
    if (lpbmi->biSize == sizeof(BITMAPINFOHEADER)) {
        long size =  lpbmi->biSizeImage;
        if (!size)
            size = WIDTHBYTES((DWORD)lpbmi->biWidth * lpbmi->biBitCount)
                * lpbmi->biHeight;
        return size;
    }
    return (DWORD) 0;
}

WORD FAR DIBBitCount (HANDLE hDIB)
{
    LPBITMAPINFOHEADER lpbmi;  // pointer to a Win 3.0-style DIB
    
    /* point to the header (whether Win 3.0 and OS/2) */

    LPSTR p = (LPSTR) GlobalLock (hDIB);
    lpbmi = (LPBITMAPINFOHEADER) p;
    
    WORD retVal =  (lpbmi->biSize == sizeof(BITMAPINFOHEADER))
        ? lpbmi->biBitCount : (WORD) 0;
    GlobalFree (hDIB);
    return retVal;
}

#endif


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
class YACL_UI CL_WriteBitStream {

public:
    CL_WriteBitStream (uchar* streamData);
    bool  Append  (ulong data, ushort nBits);
    void  Reset ();

protected:
    uchar* _data;
    uchar* _currentByte;
    short  _offset;
};


CL_WriteBitStream::CL_WriteBitStream (uchar* streamData)
{
    _data = streamData;
    Reset ();
}

void CL_WriteBitStream::Reset ()
{
    _currentByte = _data;
    _offset      = 0;
}


bool CL_WriteBitStream::Append (ulong data, ushort nBits)
{
    if (!_data)
        return FALSE;
    ulong mask = 1 << (nBits - 1);
    short outputBit = 1 << (BITS_PER_BYTE - _offset - 1);
    for (short i = 0; i < nBits; i++) {
        if (data & mask)
            *_currentByte |= outputBit;
        mask >>= 1;
        _offset ++;
        outputBit >>= 1;
        if (_offset >= BITS_PER_BYTE) {
            _offset = 0;
            _currentByte ++;
            outputBit = 1 << (BITS_PER_BYTE - 1);
        }
    }
    return TRUE;
}

// #if 1
// void Dump (uchar* bytes, short size, short cols, char* msg)
// {
//     if (!bytes)
//         return;
//     CL_Error::Warning ("\n%s\n", msg);
//     uchar* p = bytes;
//     CL_String s;
//     for (short i = 0; i < size; i++) {
//         CL_String t;
//         t.AssignWithFormat (" %02x", *p++);
//         s += t;
//         if (i % cols == cols-1) {
//             CL_Error::Warning ("%s\n", s.AsPtr());
//             s = "";
//         }
//     }
// }
// #endif

static bool Pack (const CL_IntegerSequence& pixel, ushort rows,
                  ushort cols, UI_BitmapData::ColorBitsEnum colorBits,
                  CL_ByteString& output)
{
    ushort bytesInRow = _BytesPerRow (cols, colorBits);
    if (!output.ChangeSize (bytesInRow * rows))
        return FALSE;
    uchar* outputPtr = output.AsPtr();
    for (long i = (rows - 1) * cols; i >= 0; i -= cols) {
        CL_WriteBitStream bitStream (outputPtr);
        for (long j = 0; j < cols; j++) {
            bitStream.Append (pixel[i + j], (ushort) colorBits);
        }
        outputPtr += bytesInRow;
    }
    //    Dump (output.AsPtr(), rows * bytesInRow, bytesInRow, "After pack");
    return TRUE;

}
#endif // Windows or OS/2


class YACL_UI CL_ReadBitStream {

public:
    CL_ReadBitStream (uchar* streamData);
    long  Extract  (ushort nBits);
    void  Reset ();

protected:
    uchar* _data;
    uchar* _currentByte;
    short  _offset;
};


CL_ReadBitStream::CL_ReadBitStream (uchar* streamData)
{
    _data = streamData;
    Reset ();
}

void CL_ReadBitStream::Reset ()
{
    _currentByte = _data;
    _offset      = 0;
}


long CL_ReadBitStream::Extract (ushort nBits)
{
    if (!_data)
        return -1;
    long retVal = 0;
    if (nBits == 8) // This is really a hack to improve speed
        return *_currentByte++;
    ushort mask = 1 << (BITS_PER_BYTE - _offset - 1);
    ulong outputMask = 1 << (nBits - 1);
    for (short i = 0; i < nBits; i++) {
        if ((*_currentByte) & mask)
            retVal |= outputMask;
        mask >>= 1;
        outputMask >>= 1;
        _offset ++;
        if (_offset >= BITS_PER_BYTE) {
            _offset = 0;
            _currentByte ++;
        }
    }
    return retVal;
}


// static bool RLE8_Decode (CL_IntegerSequence& pixel,
//                          const CL_Stream& bmf, long bmwidth, long
//                          bmheight, short numCBits)
// {
//     // This code doesn't work right. Maybe I'll fix it sometime. Meanwhile,
//     // I don't support run-length-encoded bitmaps.
//     bool endHit = FALSE;
//     long i = 0, j = 0, curRow = 0;
//     while (!endHit && curRow < bmheight) {
//         uchar b;
//     if (bmf.Eof()) break;
//         bmf >> b;
//         if (b) { // Non-zero
//             uchar pixelVal;
//             bmf >> pixelVal;
//             for (short n = 0; n < b; n++) {
//                 pixel (i + j) = b;
//                 j++;
//                 if (j >= bmwidth) {
//                     j = 0;
//                     i += bmwidth;
//                     curRow++;
//                 }
//             }
//         }
//         else { // Zero: beginning of coded segment
//             uchar secondByte;
//             bmf >> secondByte;
//             switch (secondByte) {
//             case 0: // End of line
//                 i = curRow * bmwidth;
//                 curRow++;
//                 j = 0;
//                 break;
// 
//             case 1: // End of bitmap
//                 endHit = TRUE;
//                 break;
// 
//             case 2: {
//                 uchar aByte;
//                 bmf >> aByte;
//                 j += aByte;
//                 bmf >> aByte;
//                 curRow += aByte;
//                 i = (curRow - 1) * bmwidth;
//                 break;
//             }
// 
//             default: {
//                 uchar aByte, byte2;
//                 bmf >> aByte;
//                 for (short n = 0; n < aByte; n++) {
//                     if (bmf.Eof()) break;
//                     bmf >> byte2;
//                     pixel (i + j) = byte2;
//                     j++;
//                     if (j >= bmwidth) {
//                         j = 0;
//                         i += bmwidth;
//                         curRow++;
//                     }
//                 }
//                 if (bmf.Offset() % 2) // Not on word boundary
//                     bmf >> aByte; // Ignore next byte
//             }
//             }
//             if (bmf.Eof()) break;
//         }
//     }
//     cout << "End at offset " << bmf.Offset() << endl;//DEBUG
//     return TRUE;
// }

static bool Unpack (uchar* input, ushort rows, ushort cols,
                    UI_BitmapData::ColorBitsEnum colorBits,
                    CL_IntegerSequence& pixel, bool /* RLEcompress */)
{
    pixel.ChangeSize (rows * cols);
    ushort bytesInRow = _BytesPerRow (cols, colorBits);
    uchar* inputPtr = input;
    if (colorBits == UI_BitmapData::Color_8Bits) {
        // Non-encoded 8-bit color
        for (long i = (rows - 1) * cols; i >= 0; i -= cols) {
            uchar* p = inputPtr;
            for (long j = 0; j < cols; j++)
                pixel(i + j) = *p++;
            inputPtr += bytesInRow;
        }
        return TRUE;
    }
    
    for (long i = (rows - 1) * cols; i >= 0; i -= cols) {
        CL_ReadBitStream bitStream (inputPtr);
        for (long j = 0; j < cols; j++) {
            pixel(i + j) = bitStream.Extract ((ushort) colorBits);
        }
        inputPtr += bytesInRow;
    }
    return TRUE;

}


UI_BitmapData::UI_BitmapData (short w, short h, ColorBitsEnum cBits,
                              short nColors,
                              ColorInfo colors[], ulong pixel[])
{
    _Init (w, h, cBits, nColors, colors, pixel);
}

void UI_BitmapData::_Init (short w, short h, ColorBitsEnum cBits,
                           short nColors,
                           ColorInfo colors[], ulong pixel[])
{
    _width = w;
    _height = h;
    long nPixels = w * h;
    _pixels.ChangeSize (nPixels);
    for (long i = 0; i < nPixels; i++)
        _pixels(i) = pixel[i];
    _numColors   = nColors;
    _nColorBits  = cBits;
    if (colors) {
        _colors      = new ColorInfo [_numColors];
        if (!_colors)
            return; // No memory
        for (short i = 0; i < _numColors; ++i ) {
            _colors [i]   = colors [i];
        }
    }
    else
        _colors = NULL;
}



UI_BitmapData::UI_BitmapData ()
{
    _colors     = NULL;
    _width      = 0;
    _height     = 0;
    _nColorBits = 0;
    _numColors  = 0;
}



UI_BitmapData& UI_BitmapData::operator = (const UI_BitmapData &o)
{
    _width       = o._width;
    _height      = o._height;
    _numColors   = o._numColors;
    _nColorBits  = o._nColorBits;
    if (_colors) {
        delete [] _colors;
        _colors = NULL;
    }
    if (o._colors) {
        _colors      = new ColorInfo [_numColors];
        for (short i = 0; i < _numColors; ++i ) {
            _colors [i] = o._colors [i];
        }
    }
    _pixels = o._pixels;
    return *this;
}


UI_BitmapData::UI_BitmapData(const UI_BitmapData& data)
{
    _colors = NULL;
    *this = data;
}


UI_BitmapData::~UI_BitmapData()
{
    if (_colors)
        delete [] _colors;
}


bool UI_BitmapData::ReadFrom (const char* fileName)
{
    CL_BinaryFile bmf (fileName, CLFile_Read);
    BitmapFileHeader  bmfh ;
   
    if (!bmf.Valid()) {
        CL_Error::Warning ("UI_Bitmap::ReadFrom: Invalid bitmap file "
                           "'%s': %s", fileName, bmf.ErrorString().AsPtr());
        return FALSE;
    }
    if (bmf.Read ((uchar *)&bmfh, sizeof(BitmapFileHeader)) != sizeof(bmfh)) {
        CL_Error::Warning ("UI_Bitmap::ReadFrom: Read failed on header: %s",
                           bmf.AsString().AsPtr());
        return FALSE;
    }
    
    if (bmfh.type[0] != 'B' || bmfh.type[1] != 'M')
        return FALSE;
    long bmoffset = _MakeLong (bmfh.offset);

    BitmapInfoHeader  bmih;
    if (bmf.Read ((uchar *) &bmih, sizeof(BitmapInfoHeader)) != sizeof(bmih)) {
        CL_Error::Warning ("UI_Bitmap::ReadFrom: Read failed on info: %s",
                           bmf.AsString().AsPtr());
        return FALSE;
    }
    if (bmih.compression) {
        CL_Error::Warning ("UI_Bitmap::ReadFrom: File %s: YACL doesn't "
                           "support RLE compression", bmf.AsString().AsPtr());
        return FALSE;
    }
    short numcbits  = _MakeShort (bmih.bcount);
    return ReadData (bmf, _MakeLong (bmih.width), _MakeLong (bmih.height),
                     numcbits, bmoffset, bmih.compression ? TRUE : FALSE);
}


bool UI_BitmapData::ReadData (const CL_Stream& bmf, long bmwidth, long
                              bmheight, short numCBits,
                              long offset, bool compress)
{
    short numcolors = 1 << numCBits;
    if (numCBits != 24) {
        ulong colrTblSize =  numcolors * sizeof (RGBQuad);
        if (!_paletteData.ChangeSize(colrTblSize))
            return FALSE; // No memory
        if (bmf.Read ((uchar *) _paletteData.AsPtr(), colrTblSize)
            != colrTblSize) {
            CL_Error::Warning ("UI_BitmapData::ReadData: Read failed on "
                               "color table: %s", bmf.ErrorString().AsPtr());
            return FALSE;
        }
    }
    if (!bmf.SeekTo (offset)) {
        CL_Error::Warning ("UI_Bitmap::ReadFrom: seek to %ld failed: %s",
                           offset, bmf.ErrorString().AsPtr());
        return FALSE;
    }
    ushort bytesInRow = _BytesPerRow (bmwidth, numCBits);
    long bitsSize = bmheight * bytesInRow;

    ColorInfo *f = new ColorInfo [numcolors];
    RGBQuad* cquad = (RGBQuad*) _paletteData.AsPtr();
    for (short i = 0; i < numcolors; ++i ) {
        f [i].red   = cquad [i].red;
        f [i].green = cquad [i].green;
        f [i].blue  = cquad [i].blue;
    }

    _width = bmwidth;
    _height = bmheight;
    _numColors   = numcolors;
    _nColorBits  = numCBits;
    _colors = f;
    _pixels.ChangeSize (bmwidth * bmheight);
//     if (numCBits == 8 && compress)
//         return RLE8_Decode (_pixels, bmf, bmwidth, bmheight, numCBits);

    CL_ByteString bits (bitsSize);

    if (bmf.Read (bits, bitsSize) < bitsSize) {
        CL_Error::Warning ("UI_BitmapData::ReadData: read of bits failed: %s",
                           bmf.ErrorString().AsPtr());
        return FALSE;
    }

    // Dump (bits.AsPtr(), bitsSize, bytesInRow, "After read");
    Unpack (bits.AsPtr(), bmheight, bmwidth,
            (UI_BitmapData::ColorBitsEnum) numCBits, _pixels, compress);
    return TRUE;
}



// --------------------------- Bitmap methods ---------------------------

UI_Bitmap::UI_Bitmap ()
{
    _rep = new UI_BitmapRep;
    _rep->Ref();
}


UI_Bitmap::UI_Bitmap (const UI_Bitmap& b)
{
    *this = b;
}

UI_Bitmap& UI_Bitmap::operator= (const UI_Bitmap& b)
{
    if (PrepareToChange()) {
        _CleanUp ();
        _rep = b._rep;
        _rep->Ref ();
        Notify ();
    }
    return *this;
}

bool UI_Bitmap::BuildFrom (const UI_BitmapData& bi, UI_DrawingSurface* sfc)
{
    if (PrepareToChange()) {
        _CleanUp ();
        _rep = new UI_BitmapRep;
        _CreateBitmapFromData (bi, sfc);
        _rep->Ref ();
        Notify();
        return TRUE;
    }
    return FALSE;
}



bool UI_Bitmap::BuildFrom (const char* name, UI_DrawingSurface*
#if !defined(__MS_WINDOWS__) && !defined(__MS_WIN32__)
                           sfc
#endif
                           )
{
    if (!PrepareToChange())
        return FALSE;
    if (!CL_BinaryFile::Exists (name, CLFile_Read)) {
        CL_Error::Warning ("UI_Bitmap::BuildFrom: cannot read file '%s'",
                           name);
        return FALSE;
    }
    _CleanUp ();
    _rep = new UI_BitmapRep;
    _rep->Ref ();
    bool retVal = FALSE;
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (name && name[0] == '+') {
        short i;
        for (i = 0; BuiltIn[i].name != 0; i++) {
            if (CL_String (name) == BuiltIn[i].name)
                break;
        }
        if (BuiltIn [i].name != 0)
            _rep->_handle = LoadBitmap (NULL, (LPSTR) BuiltIn[i].code);
        if (_rep->_handle)
            _rep->_hDIB = BitmapToDIB (_rep->_handle, 0);
        retVal = TRUE;
    }
    else {
        _rep->_hDIB = LoadDIB ((char*) name);
        if (_rep->_hDIB) {
            LPSTR lp = (LPSTR) GlobalLock (_rep->_hDIB);
            _width  = DIBWidth    (lp);
            _height = DIBHeight   (lp);
            LPBITMAPINFOHEADER lpbmi = (LPBITMAPINFOHEADER) lp;
            if (lpbmi->biSize == sizeof(BITMAPINFOHEADER))
                _bitsPerPixel = lpbmi->biBitCount;
            else
                _bitsPerPixel = 0;
            GlobalUnlock (_rep->_hDIB);
            if (_bitsPerPixel >= 8) // Don't create a palette for bitmaps with
                                    // 16 or fewer colors
                _rep->_paletteHandle = CreateDIBPalette(_rep->_hDIB);
            _rep->_handle = DIBToBitmap (_rep->_hDIB, _rep->_paletteHandle);
        }
        retVal = _rep->_hDIB != 0;
    }
#elif defined(__OS2__)
    short bmheight = 0, bmwidth = 0;

// codes nicked from fbmp.c by Raja Thiagarajan
    // Some modifications by M. A. Sridhar, Dec 23, 1995
    FILE * bmpFile;
    LONG   fSize;
    VOID  * bPtr;

    bmpFile = fopen (name, "rb");
    if (bmpFile == NULL) {
        CL_Error::Warning ("UI_Bitmap::BuildFrom: Can't open %s", name);
        return FALSE;
    }

    /* Check to see if it has the right format */
    CHAR ut [2];
    fread (ut, sizeof (CHAR), 2, bmpFile);
    if ((ut[0] != 'B') || (ut[1] != 'M')) {
        fclose (bmpFile);
        CL_Error::Warning ("UI_Bitmap::BuildFrom: Invalid bitmap file '%s'",
                           name);
        return FALSE;
    }

    /* Determine the size of the file */
    fseek (bmpFile, 0L, SEEK_END);
    fSize = ftell (bmpFile);

    /* Allocate that much free memory. [Boy, do I love virtual, flat-model
       memory!] */
    bPtr = new uchar[fSize];
    if (bPtr == NULL) {
        fclose (bmpFile);
        return FALSE;
    }

    /* Move back to the start of the file ...*/
    fseek (bmpFile, 0L, SEEK_SET);
    /* ... and load the whole thing in one gulp! */
    fread (bPtr, sizeof (BYTE), fSize, bmpFile);

    /* Now close the file [since we can read from RAM instead!] */
    fclose (bmpFile);

    /* As long as we're here, set the width, height, and bits per plane */
    PBITMAPFILEHEADER2 pbfh2 = (PBITMAPFILEHEADER2) bPtr;
    bmheight = pbfh2->bmp2.cy;
    bmwidth  = pbfh2->bmp2.cx;
    USHORT bBits = pbfh2->bmp2.cBitCount;
    short numcbits  = bBits;
    BYTE * foo = (BYTE*) bPtr;

    /* Create and load palette */
    HPS     hps = 0;
    bool    ownPS = FALSE;
    if (sfc)
        hps = sfc->Handle();
    else {
        hps = WinGetPS (HWND_DESKTOP);
        ownPS = TRUE;
    }
    ULONG oldPalette = 0;
    if (bBits >= 8) { // We don't create a palette for bitmaps with 16 or
                      // fewer colors
        if (_rep->_paletteHandle)
            GpiDeletePalette (_rep->_paletteHandle);
        _rep->_paletteHandle = GpiCreatePalette
            (YACLApp()->Controller().AnchorBlockHandle(), 0L, LCOLF_CONSECRGB,
             1 << bBits, (PULONG) (foo + 54));
        oldPalette = GpiSelectPalette (hps, _rep->_paletteHandle); 
    }

    _width = bmwidth;
    _height = bmheight;
    _bitsPerPixel = numcbits;
    
    /* Create bitmap */
    HBITMAP hbm = GpiCreateBitmap
        (hps, &(pbfh2->bmp2), CBM_INIT, (foo + pbfh2->offBits),
         (PBITMAPINFO2) &(pbfh2->bmp2));
    if (!hbm)
        CL_Error::Warning ("UI_Bitmap::BuildFrom: GpiCreateBitmap failed!");
    _rep->_handle = hbm;
    if (oldPalette)
        GpiSelectPalette (sfc->Handle(), oldPalette);
    /* We don't need the file image any more, so ... */
    delete [] bPtr;
    if (ownPS)
        WinReleasePS (hps);
    retVal = TRUE;
#else
    UI_BitmapData data;
    if (!data.ReadFrom (name))
        return FALSE;
    if (!_CreateBitmapFromData (data, sfc)) {
        CL_Error::Warning ("UI_Bitmap::BuildFrom: create failed "
                           "for file '%s'", name);
        return FALSE;
    }
    return TRUE;
#endif
    Notify ();
    return retVal;

}





UI_Bitmap::~UI_Bitmap ()
{
    _CleanUp ();
}

void UI_Bitmap::_CleanUp ()
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    _rep->Unref ();
    if (_rep->_refCount <= 0) {
        if (_rep->_handle) {
            DeleteObject (_rep->_handle);
            _rep->_handle = 0;
        }
        if (_rep->_hDIB) {
            GlobalFree (_rep->_hDIB);
            _rep->_hDIB = 0;
        }
        if (_rep->_paletteHandle) {
            DeleteObject (_rep->_paletteHandle);
            _rep->_paletteHandle = 0;
        }
        delete _rep;
    }
#elif defined(__OS2__)
    _rep->Unref ();
    if (_rep->_refCount <= 0) {
        if (_rep->_handle) {
            GpiDeleteBitmap (_rep->_handle);
            _rep->_handle = 0;
        }
        if (_rep->_paletteHandle) {
            GpiDeletePalette (_rep->_paletteHandle);
            _rep->_paletteHandle = 0;
        }
        delete _rep;
    }
#elif defined (__X_MOTIF__) || defined(__X_YACL__)
    _rep->Unref ();
    if (_rep->_refCount <= 0) {
        if (_rep->_handle) {
            free (_rep->_handle->data);
            _rep->_handle->data = 0;
            XDestroyImage (_rep->_handle);
        }
        delete _rep;
    }
#endif
    _rep = 0; // Safer to have a NULL pointer than a dangling one
}



bool UI_Bitmap::DrawOn (UI_DrawingSurface& s, const UI_Point& p) const
{
    s.DrawBitmap ((const UI_Bitmap&) *this, p);
    return TRUE;
}


#if defined(__OS2__)
// CL_String PrintForm (RECTL* rect)
// { // For debugging
//     CL_String s;
//     s.AssignWithFormat ("xLeft %d yBottom %d xRight %d yTop %d",
//                         rect->xLeft, rect->yBottom, rect->xRight,
//                         rect->yTop);
//     return s;
// }
#endif



void UI_Bitmap::CopyFrom (UI_DrawingSurface& s, const UI_Rectangle& r)
{
    if (!PrepareToChange())
        return;
    _CleanUp ();
    _rep = new UI_BitmapRep;
    _rep->Ref ();
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    HDC srcdc = s.Handle();
    if (!srcdc)
        return;
    HDC destdc = CreateCompatibleDC (srcdc);
    if (!destdc)
        return;
    if (_rep->_handle)
        DeleteObject (_rep->_handle);
    long w = r.Width() ;
    long h = r.Height();
    _rep->_handle = CreateCompatibleBitmap (srcdc, w, h);
    HBITMAP hOldBm = SelectObject (destdc, _rep->_handle);
    SetMapMode (destdc, GetMapMode (srcdc));
    BitBlt (destdc, 0, 0,  r.Width(), r.Height(), srcdc, r.Left(), r.Top(),
            SRCCOPY);
    _rep->_handle = SelectObject (destdc, hOldBm);
    DeleteDC (destdc);
    _rep->_hDIB = BitmapToDIB (_rep->_handle, 0);
    _bitsPerPixel = DIBBitCount (_rep->_hDIB);
#elif defined(__OS2__)
    HDC hdc = GpiQueryDevice ((HPS) s.Handle());
    HAB hab = YACLApp()->Controller().AnchorBlockHandle();
    HDC hdcMem = DevOpenDC (hab, OD_MEMORY, "*", 0L, NULL, hdc);
    SIZEL sizel;
    sizel.cx = sizel.cy = 0;
    HPS hpsMem = GpiCreatePS (hab, hdcMem, &sizel, PU_ARBITRARY |
                              GPIT_MICRO | GPIA_ASSOC);
    long colorPlanes, colorBitCount;
    DevQueryCaps (s.Handle(), CAPS_COLOR_PLANES, 1L, &colorPlanes);
    DevQueryCaps (hdc, CAPS_COLOR_BITCOUNT, 1L, &colorBitCount);

    if (_rep->_handle != NULLHANDLE)
        GpiDeleteBitmap (_rep->_handle);

    // Now create a bitmap.
    BITMAPINFOHEADER bmp;
    bmp.cbFix = sizeof(BITMAPINFOHEADER);
    bmp.cx = (SHORT) r.Width();
    bmp.cy = (SHORT) r.Height();
    bmp.cPlanes   = (SHORT) colorPlanes;
    bmp.cBitCount = (SHORT) colorBitCount;
    _rep->_handle = GpiCreateBitmap (hpsMem, (PBITMAPINFOHEADER2) &bmp,
                               0x0000, NULL, NULL);
    GpiSetBitmap (hpsMem, _rep->_handle);

    GpiSetColor (hpsMem, CLR_TRUE);
    GpiSetBackColor (hpsMem, CLR_FALSE);
    GpiSetBackMix (hpsMem, BM_OVERPAINT);
    
    POINTL pt[4];
    pt[0].x = pt[0].y = 0;
    pt[1].x = r.Width() - 1;
    pt[1].y = r.Height() - 1;
    pt[2].x = r.Left ();
    pt[2].y = s.DrawingArea().Height() - r.Bottom() - 1;
    pt[3].x = pt[2].x + r.Width();
    pt[3].y = pt[2].y + r.Height() + 1;
    GpiBitBlt (hpsMem, (HPS) s.Handle(), 4, pt, ROP_SRCCOPY, BBO_AND);
//     CL_Error::Warning ("Bitmap CopyFrom: dest %s src %s\n",
//                        PrintForm ((RECTL*) &pt).AsPtr(),
//                        PrintForm ((RECTL*) &pt[2]).AsPtr()); //DEBUG
    GpiDestroyPS (hpsMem);
    DevCloseDC   (hdcMem);
    
#elif defined (__X_MOTIF__) || defined(__X_YACL__)
    Display *dpy  = YACLApp()->AppDisplay ();
    Drawable d    = s._Drawable ();

    if (d) {
        int format = DefaultDepth (dpy, DefaultScreen(dpy)) == 1 ? XYPixmap
            : ZPixmap;
        _rep->_handle = XGetImage (dpy, d, r.Left(), r.Top(), r.Width(), r.Height(),
                             AllPlanes, format);
        // Must fix the above to check for r being within client area
    }
#endif
    _width  = r.Width();
    _height = r.Height();
    Notify ();
}



bool UI_Bitmap::_CreateBitmapFromData (const UI_BitmapData& bi, 
                                       UI_DrawingSurface*   sfc)
{
    _width        = bi.Width();
    _height       = bi.Height();
#if defined (__MS_WINDOWS__)  || defined(__MS_WIN32__)
    long nColors = bi.ColorCount();
    const CL_IntegerSequence& pixels = bi.Pixels();
    CL_ByteString bits;
    short nColorBits = bi.ColorBitsCount();
    Pack (pixels, _height, _width,
          (UI_BitmapData::ColorBitsEnum) nColorBits, bits);
    short rgbQuadArraySize = nColorBits <= 8 ? (1 << nColorBits) : nColors;
    short bytesNeeded = sizeof (BITMAPINFOHEADER) + sizeof (RGBQUAD) *
        rgbQuadArraySize  + bits.Size();
    HANDLE hloc      = GlobalAlloc (GHND, bytesNeeded);
    PBITMAPINFO pbmi = (PBITMAPINFO) GlobalLock (hloc);

    pbmi->bmiHeader.biSize        = sizeof (BITMAPINFOHEADER);
    pbmi->bmiHeader.biWidth       = bi.Width();
    pbmi->bmiHeader.biHeight      = bi.Height();
    pbmi->bmiHeader.biPlanes      = 1;
    pbmi->bmiHeader.biBitCount    = bi.ColorBitsCount();
    pbmi->bmiHeader.biCompression = 0;
    pbmi->bmiHeader.biSizeImage   = bits.Size();
    pbmi->bmiHeader.biClrUsed     = nColorBits <= 8 ? nColors : 0;
    if (nColors) {
        UI_BitmapData::ColorInfo* colors = bi.Colors();
        for (long i = 0; i < nColors; i++) {
            RGBQUAD& quad =  pbmi->bmiColors[i];
            UI_BitmapData::ColorInfo& p = colors[i];
            quad.rgbBlue  = p.blue;
            quad.rgbGreen = p.green;
            quad.rgbRed   = p.red;
            quad.rgbReserved = 0;
        }
    }

    uchar* bitPtr = ((uchar*) pbmi) + sizeof (BITMAPINFOHEADER) +
        sizeof (RGBQUAD) *  rgbQuadArraySize;
    memcpy (bitPtr, bits.AsPtr(), bits.Size());
    bool ownDC = FALSE;
    HDC hdc;
    if (sfc)
        hdc = sfc->Handle ();
    else {
        hdc = CreateDC ("DISPLAY", NULL, NULL, NULL);
        ownDC = TRUE;
    }
    HBITMAP hbm = CreateDIBitmap (hdc, (BITMAPINFOHEADER FAR *) pbmi, CBM_INIT,
                                  bitPtr, pbmi, DIB_RGB_COLORS);
    if (!hbm)
        return FALSE;

    GlobalUnlock (hloc);
    GlobalFree (hloc);
    if (_rep->_handle)
        DeleteObject (_rep->_handle);
    _rep->_handle = hbm;
    if (_rep->_hDIB) {
        GlobalUnlock (_rep->_hDIB);
        GlobalFree (_rep->_hDIB);
    }
    _rep->_hDIB = BitmapToDIB (_rep->_handle, 0);
    _bitsPerPixel = DIBBitCount (_rep->_hDIB);
    if (ownDC)
        DeleteDC (hdc);
    return TRUE;
    
#elif defined (__OS2__)
    BITMAPINFO2       *pbmi;
    BITMAPINFOHEADER2  bmi ;
    memset (&bmi, 0, sizeof bmi);

    bmi.cbFix     = sizeof (BITMAPINFOHEADER2); 
    bmi.cx        = bi.Width();
    bmi.cy        = bi.Height();
    bmi.cPlanes   = 1;
    bmi.cBitCount = bi.ColorBitsCount();

    pbmi = (BITMAPINFO2 *) new uchar [sizeof (BITMAPINFO2) + 
                                      (bi.ColorCount() * sizeof (RGB2))];
    memset (pbmi, 0, sizeof (BITMAPINFO2));
    pbmi->cbFix     = sizeof (BITMAPINFOHEADER2);
    pbmi->cx        = bi.Width();
    pbmi->cy        = bi.Height();
    pbmi->cPlanes   = 1;
    pbmi->cBitCount = bi.ColorBitsCount();
    pbmi->cclrUsed  = bi.ColorCount();
    for (short i = 0; i < pbmi->cclrUsed; ++i) {
        pbmi->argbColor [i].bBlue  = bi.Color (i).blue;
        pbmi->argbColor [i].bGreen = bi.Color (i).green;
        pbmi->argbColor [i].bRed   = bi.Color (i).red;
    }

    
    HPS  hps;
    bool ownPS = FALSE;
    if (sfc)
        hps = sfc->Handle();
    else {
        ownPS = TRUE;
        hps = WinGetPS (HWND_DESKTOP);
    }
    CL_ByteString bits;
    Pack (bi.Pixels(), bi.Height(), bi.Width(), 
          (UI_BitmapData::ColorBitsEnum) bi.ColorBitsCount(), bits);
    HBITMAP hbm = GpiCreateBitmap
        (hps, &bmi, CBM_INIT, (char*) bits.AsPtr(), pbmi);

    if (_rep->_handle)
        GpiDeleteBitmap (_rep->_handle);
    _rep->_handle = hbm;
    _bitsPerPixel = bi.ColorBitsCount();
    if (ownPS)
        WinReleasePS (hps);
    delete [] pbmi;
    return TRUE;
    
#elif defined (__X_MOTIF__) || defined(__X_YACL__)
    ulong h = bi.Height(), w = bi.Width();
    _bitsPerPixel = bi.ColorBitsCount();
    XColor xcolor;
    Display *dpy      = YACLApp()->AppDisplay();
    short screen_num  = DefaultScreen (dpy);
    Visual  *v        = DefaultVisual (dpy, screen_num);
    int depth         = DefaultDepth (dpy, screen_num);
    int format        = (depth == 1 ? XYPixmap: ZPixmap);
    int pad           = (depth == 1 ? 32 : ((depth > 8) ? 32 : 8));
    
    _rep->_handle = XCreateImage (dpy, v, depth, format, 0, 0,
                            bi.Width(), bi.Height(), pad, w * 4);
    _rep->_handle->data = (char*) malloc (sizeof (long) * w * h);
    // I use malloc here, rather than new, because this data will have to be
    // freed (not delete'd) in _CleanUp. This is because _CleanUp doesn't
    // know whether the image data was created via XCreateImage (in this
    // method) or XGetImage (in CopyFrom).
    if (_bitsPerPixel >= 24) {
        CL_Error::Warning ("UI_Bitmap::UI_Bitmap: 24 Bit color"
                           " not supported");
        return FALSE;
    }

    CL_IntegerSequence pixelSeq (bi.ColorCount());
    UI_BitmapData::ColorInfo* info = bi.Colors();
    for (long ii = bi.ColorCount() - 1; ii >= 0; ii--) {
        xcolor.red   = ((info[ii].red   + 1) << 8) - 1;
        xcolor.blue  = ((info[ii].blue  + 1) << 8) - 1;
        xcolor.green = ((info[ii].green + 1) << 8) - 1;
        XAllocColor (dpy, DefaultColormap (dpy, screen_num),
                     &xcolor);
        pixelSeq (ii) = xcolor.pixel;
    }
    const CL_IntegerSequence& pixels = bi.Pixels();
    register long pixelIndex = 0;
    for (short i = 0; i < h; ++i) {
        for (short j = 0; j < w; ++j) {
            ulong pixelVal = pixels(pixelIndex++);
            XPutPixel (_rep->_handle, j, i,  pixelSeq(pixelVal));
            // printf ("%4d", pixelVal);
        }
        // printf ("\n");
    }

    return TRUE;
#endif
}




