

#include "base/integer.h"
#include "base/binding.h"

#include "ui/bmpbtn.h"
#include "ui/cntroler.h"
#include "ui/dsplsurf.h"
#include "ui/shadorec.h"

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
extern "C" {
#include "ui/support/windows/dibapi.h"     // Thank you MSDN
}
#elif defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <Xm/Label.h>
#    include <X11/Intrinsic.h>
#elif defined(__OS2__)
#    include <string.h>
#endif


#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding0<UI_BitmapButton>;
#elif defined(_MSC_VER)
template CL_Binding0<UI_BitmapButton>;
#endif


typedef CL_Binding0<UI_BitmapButton> BitmapBtnBind;

UI_BitmapButton::UI_BitmapButton (UI_VisualObject* parent,
                                  const UI_Rectangle& shape,
                                  UI_ViewID id)
: UI_SimpleVObject (parent, shape, id)
{
    BitmapBtnBind ebind   (this, &UI_BitmapButton::_EnabledBitmapChanged);
    _enabledBitmap.AddDependent (ebind);
    BitmapBtnBind dbind   (this, &UI_BitmapButton::_DisabledBitmapChanged);
    _disabledBitmap.AddDependent (dbind);
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style = WS_CHILD | WS_VISIBLE;
#elif defined(__OS2__)
    _style = WS_VISIBLE;
#endif
}


UI_BitmapButton::~UI_BitmapButton ()
{
}


void UI_BitmapButton::_PrivateInitialize ()
{
    UI_SimpleVObject::_PrivateInitialize ();
#if defined(__OS2__) || defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    // The first WM_PAINT is sent even before CreateWindow returns, so at
    // that point the handle is not in the Controller's visual object map.
    // So it cannot dispatch that event correctly. So we force another paint
    // event here:
    Invalidate();
#elif defined(__X_MOTIF__)
    _SetEnabledBitmap ();
    _SetDisabledBitmap ();
#endif
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
bool UI_BitmapButton::HandleEvent (UI_Event* e)
{
#if defined(__OS2__)
    QMSG* message = e->NativeEvent();
    if (!message)
        return UI_SimpleVObject::HandleEvent (e);
    ULONG msg = message->msg;
    if (!IsEnabled() && msg != WM_PAINT)
        return TRUE; // Don't even let the event go up the view tree
    switch (msg) {
    case WM_CHAR: {
        short theChar = SHORT1FROMMP(message->mp2);
        short flags   = SHORT1FROMMP(message->mp1);
        if ((theChar & 0xff) != ' ')
            break;
        if ((flags & KC_KEYUP) == 0) {
            Press ();
            DrawRecessed ();
        }
        else {
            Release ();
            IsRaised() ? DrawRaised() : DrawRecessed();
            UI_Event selectEvt (Event_Select, this, this);
            _Controller->DispatchEvent (&selectEvt);
        }
        break;
    }
        
    case WM_PAINT:
        IsRaised() ? DrawRaised() : DrawRecessed();
        return FALSE;

    case WM_BUTTON1DOWN:
        TakeFocus();
        Press ();
        DrawRecessed ();
        WinSetCapture (HWND_DESKTOP, _handle);
        break;

    case WM_BUTTON1UP: {
        WinSetCapture (HWND_DESKTOP, 0);
        Release ();
        IsRaised() ? DrawRaised() : DrawRecessed();
        UI_Event selectEvt (Event_Select, this, this);
        _Controller->DispatchEvent (&selectEvt);
        break;
    }

    case  WM_SETFOCUS:
        if (SHORT1FROMMP (message->mp2)) {
            // Draw focus rectangle
        }
        else {
            // Erase focus rectangle
        }
        break;

    default:
        break;
    }
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    MSG* message = e->NativeEvent();
    if (!message)
        return UI_SimpleVObject::HandleEvent (e);
    long msg = message->message;
    switch (msg) {
    case WM_KEYDOWN: {
        short theChar = message->wParam;
        if (theChar == ' ') {
            Press ();
            DrawRecessed ();
        }
        break;
    }

    case WM_KEYUP: {
        short theChar = message->wParam;
        if (theChar == ' ') {
            Release ();
            IsRaised() ? DrawRaised() : DrawRecessed();
            UI_Event selectEvt (Event_Select, this, this);
            _Controller->DispatchEvent (&selectEvt);
        }
        break;
    }
        
    case WM_PAINT:
        IsRaised() ? DrawRaised() : DrawRecessed();
        return FALSE; // Don't want 'break' here, because the
                      // SimpleVObject's default implemenation indirectly
                      // does a FillWithBgColor.

    case WM_LBUTTONDOWN:
        TakeFocus();
        Press ();
        DrawRecessed ();
        SetCapture (_handle);
        break;

    case WM_LBUTTONUP: {
        ReleaseCapture ();
        Release ();
        IsRaised() ? DrawRaised() : DrawRecessed();
        UI_Event selectEvt (Event_Select, this, this);
        _Controller->DispatchEvent (&selectEvt);
        break;
    }

    case  WM_SETFOCUS:
            // Draw focus rectangle
        break;

    case WM_KILLFOCUS:
            // Erase focus rectangle
        break;


    default:
        break;
    }
#endif
    return UI_SimpleVObject::HandleEvent (e);
}


void UI_BitmapButton::_DrawBitmap (UI_DwgSurfHandle h)
{
#if defined(__OS2__)
    UI_BitmapHandle bmph =  (_enabled || !_disabledBitmap.Handle())
        ? _enabledBitmap.Handle()
        : _disabledBitmap.Handle();
    RECTL rect;
    WinQueryWindowRect (_handle, &rect);
    rect.xLeft  += 8; rect.yBottom += 8;
    rect.xRight -= 8; rect.yTop    -= 8;
    WinDrawBitmap (h, bmph, NULL,
                   (PPOINTL) &rect, 0, 0, DBM_NORMAL | DBM_STRETCH);
    if (!_enabled && !_disabledBitmap.Handle())
        _DrawDisabledBitmap (h);
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_enabled) {
        RECT rect;
        GetClientRect (_handle, &rect);
        rect.left  += 8; rect.bottom -= 8;
        rect.right -= 8; rect.top    += 8;
        RECT dibRect;
        dibRect.left   = dibRect.top = 0;
        dibRect.right  = _enabledBitmap.Width();
        dibRect.bottom = _enabledBitmap.Height();
        PaintBitmap (h, &rect, _enabledBitmap.Handle(), &dibRect,
                     NULL);
    }
    else
        _DrawDisabledBitmap (h);
#endif
}

void UI_BitmapButton::DrawRaised ()
{
    // Draw in up state
    UI_DisplaySurface& sfc = CreateDisplaySurface();
    UI_ShadowRectangle srect (Shape(), UI_ShadowRectangle::Raised, 2);
    srect.Origin (UI_Point (0, 0));
    srect.DrawOn (sfc);
    _DrawBitmap(sfc.Handle());
    DestroyDisplaySurface();
}

void UI_BitmapButton::DrawRecessed ()
{
    // Draw in down state
    UI_DisplaySurface& sfc = CreateDisplaySurface();
    UI_ShadowRectangle srect (Shape(), UI_ShadowRectangle::Recessed, 2);
    srect.Origin (UI_Point (0, 0));
    srect.DrawOn (sfc);
    UI_Rectangle outerRect (0, 0, Shape().Width(), Shape().Height());
    sfc.Pen().Color (UIColor_Black);
    outerRect.DrawOn (sfc);
    _DrawBitmap (sfc.Handle());
// #if defined(__OS2__)
//     RECTL rect;
//     WinQueryWindowRect (_handle, &rect);
//     rect.xLeft  += 10; rect.yBottom += 6;
//     rect.xRight -= 6; rect.yTop    -= 10;
//     WinDrawBitmap (sfc.Handle(), _enabledBitmap.Handle(), NULL,
//                    (PPOINTL) &rect, 0, 0, DBM_NORMAL | DBM_STRETCH);
//     if (!_enabled)
//         _DrawDisabledBitmap (sfc.Handle ());
// #elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
//     if (_enabled) {
//         RECT rect;
//         GetClientRect (_handle, &rect);
//         rect.left  += 8; rect.bottom -= 8;
//         rect.right -= 8; rect.top    += 8;
//         RECT dibRect;
//         dibRect.left   = dibRect.top = 0;
//         dibRect.right  = _enabledBitmap.Width();
//         dibRect.bottom = _enabledBitmap.Height();
//         PaintBitmap (sfc.Handle(), &rect, _enabledBitmap.Handle(), &dibRect,
//                      NULL);
//     }
//     else
//         _DrawDisabledBitmap (sfc.Handle());
// #endif
    DestroyDisplaySurface();
}


#endif // Windows or OS/2


UI_WindowClass UI_BitmapButton::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    return _YACLSimpleClassName;
#elif defined(__X_MOTIF__)
    CL_Error::Warning ("UI_BitmapButton::WindowClass: should not be called!"); 
    return 0;
#endif
}

bool UI_BitmapButton::_EnabledBitmapChanged ()
{
#if defined(__X_MOTIF__)
    _SetEnabledBitmap();
#endif
    Invalidate ();
    return TRUE;
}


bool UI_BitmapButton::_DisabledBitmapChanged ()
{
#if defined(__X_MOTIF__)
    _SetDisabledBitmap();
#endif
    Invalidate ();
    return TRUE;
}


bool UI_BitmapButton::Enable ()
{
#if defined(__OS2__)
    // Under OS/2, we don't want WinEnableWindow() to be called, because
    // painting doesn't occur if we do. So we don't call
    // SimpleVObject::Disable. Instead:
    _enabled = TRUE;
    Invalidate ();
    return TRUE;
#else
    bool b = UI_SimpleVObject::Enable ();
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    Invalidate ();
#endif
    return b;
#endif
}


bool UI_BitmapButton::Disable ()
{
#if defined(__OS2__)
    // Under OS/2, we don't want WinEnableWindow() to be called, because
    // painting doesn't occur if we do. So we don't call
    // SimpleVObject::Disable. Instead:
    _enabled = FALSE;
    Invalidate ();
    return TRUE;
#else
    bool b = UI_SimpleVObject::Disable ();
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    Invalidate ();
#endif
    return b;
#endif
}


#if defined(__X_MOTIF__)
void UI_BitmapButton::_SetEnabledBitmap ()
{
    if (!_xwidget || !_enabledBitmap.Handle())
        return;
    XGCValues xvalues;
    Display *dpy      = _Application->AppDisplay();
    short screen_num  = DefaultScreen (dpy);
    int depth         = DefaultDepth (dpy, screen_num);
    long width        = _enabledBitmap.Width();
    long height       = _enabledBitmap.Height();
    UI_ViewHandle h   = _xwidget;
    Window win = XtWindow (h); // DEBUG
    Pixmap pmap       = XCreatePixmap (XtDisplay(h),  XtWindow(h),
                                       width, height, depth);
    GC gc             = XCreateGC (dpy, XtWindow (h), 0, &xvalues);
    XPutImage (dpy, pmap, gc, _enabledBitmap.Handle(), 0, 0, 0, 0, width,
               height);
    Pixmap oldPixmap;
    XtVaGetValues (h, XmNlabelPixmap, &oldPixmap, 0);
    XtVaSetValues (h, XmNlabelPixmap, pmap, 0);
    if (oldPixmap != XmUNSPECIFIED_PIXMAP)
        XFreePixmap (dpy, oldPixmap);
    XFreeGC (dpy, gc);
}


void UI_BitmapButton::_SetDisabledBitmap ()
{
    if (!_xwidget)
        return;
    UI_Bitmap& bmp = _disabledBitmap.Handle() ? _disabledBitmap :
        _enabledBitmap;
    XGCValues xvalues;
    Display *dpy      = _Application->AppDisplay();
    short screen_num  = DefaultScreen (dpy);
    int depth         = DefaultDepth (dpy, screen_num);
    long width        = bmp.Width();
    long height       = bmp.Height();
    UI_ViewHandle h   = _xwidget;
    Pixmap pmap       = XCreatePixmap (XtDisplay(h),  XtWindow(h),
                                       width, height, depth);
    GC gc             = XCreateGC (dpy, XtWindow (h), 0, &xvalues);
    XPutImage (dpy, pmap, gc, bmp.Handle(), 0, 0, 0, 0, width,
               height);
    Pixmap oldPixmap;
    XtVaGetValues (h, XmNlabelInsensitivePixmap, &oldPixmap, 0);
    XtVaSetValues (h, XmNlabelInsensitivePixmap, pmap, 0);
    if (oldPixmap != XmUNSPECIFIED_PIXMAP)
        XFreePixmap (dpy, oldPixmap);
    XFreeGC (dpy, gc);
}


void UI_BitmapButton::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;
    UI_SimpleVObject::_SetupStyle (arg, argn);
    // Add other resource specs:
    XtSetArg  (arg [argn], XmNrecomputeSize, FALSE); argn++;
    XtSetArg  (arg [argn], XmNlabelType,     XmPIXMAP); argn++;
}


#endif



#if defined(__OS2__)
bool UI_BitmapButton::_DrawDisabledBitmap (HPS hps)
{
    RECTL rect;
    WinQueryWindowRect (_handle, &rect);
    rect.xLeft  += 4; rect.yBottom += 4;
    rect.xRight -= 4; rect.yTop    -= 4;
    GpiSetPattern (hps, PATSYM_DIAG1);
    GpiSetMix (hps, FM_SUBTRACT);
    GpiMove  (hps, (PPOINTL) &rect);
    GpiBox (hps, DRO_FILL, ((PPOINTL) &rect) + 1, 0L, 0L);
    return TRUE;
}
#endif

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)



bool UI_BitmapButton::_DrawDisabledBitmap (UI_DwgSurfHandle hdc)
{
    long bw = _enabledBitmap.Width(), bh = _enabledBitmap.Height ();
    RECT dibRect;
    dibRect.left   = dibRect.top = 0;
    dibRect.right  = bw;
    dibRect.bottom = bh;

    RECT rect;
    GetClientRect (_handle, &rect);

    if (_disabledBitmap.Handle()) {
        rect.left  += 8; rect.bottom -= 8;
        rect.right -= 8; rect.top    += 8;
        PaintBitmap (hdc, &rect, _disabledBitmap.Handle(), &dibRect,
                     NULL);
        return TRUE;
    }

    rect.bottom -= 16;  rect.right -= 16;
    long destW = rect.right - rect.left + 1;
    long destH = rect.bottom - rect.top + 1;
    // No disabled bitmap specified, so render the enabled bitmap in
    // grayed form:
    
    HDC hdcMono = CreateCompatibleDC(NULL);
    if (!hdcMono)
        return FALSE;
    HBITMAP hbmMono = CreateBitmap(destW, destH, 1, 1, NULL);
    if (!hbmMono)
        return FALSE;

    HBITMAP hbmDefault = SelectObject(hdcMono, hbmMono);

    PatBlt(hdcMono, 0, 0, destW, destH, WHITENESS);
    PaintBitmap (hdcMono, &rect, _enabledBitmap.Handle(), &dibRect, NULL);


    COLORREF btnFace    = GetSysColor (COLOR_BTNFACE);
    COLORREF btnHilight = GetSysColor (COLOR_BTNHIGHLIGHT);
//    COLORREF btnShadow  = GetSysColor (COLOR_BTNSHADOW);
    HBRUSH hbrBtnFace = CreateSolidBrush (btnFace);
    HBRUSH hbrBtnHilight = CreateSolidBrush (btnHilight);
//    HBRUSH hbrBtnShadow = CreateSolidBrush (btnShadow);
//    HBRUSH blackBrush = CreateSolidBrush (0);
    HBRUSH whiteBrush = CreateSolidBrush (0x00fffffL);

    HBRUSH hOldBrush = SelectObject (hdc, whiteBrush);
    SetTextColor(hdc, 0);	 // 0's in mono -> 0 (for ROP)
    SetBkColor(hdc,  0xffffffL); // 1's in mono -> 1

    BitBlt(hdc, 9, 9, destW-1, destH-1, hdcMono, 0, 0, SRCPAINT); //0x47076a);

//     SelectObject (hdc, hbrBtnFace);
//     BitBlt(hdc, 8, 8, destW, destH, hdcMono, 0, 0, SRCERASE);
    SelectObject (hdc, hOldBrush);
    DeleteObject (hbrBtnFace);
    DeleteObject (hbrBtnHilight);
    
    SelectObject (hdcMono, hbmDefault);
    DeleteObject (hbmMono);
    DeleteDC (hdcMono);
    
    return TRUE;

}

#endif
