

#ifndef _bmpushbn_h_ 
#define _bmpushbn_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


// BitmapPushButton is a VisualObject that behaves just like a PushButton,
// except that it displays a bitmap instead of text.
// It does not use its title string.
//
// The bitmap displayed by the button is available via its Bitmap() method.
// Modifying the return value of this method causes the button to change its
// display.


#if defined(__GNUC__)
#pragma interface
#endif



#include "base/integer.h"
#include "ui/bmpbtn.h"

class YACL_UI UI_CompositeVObject;
class YACL_UI UI_BitmapPushButton: public UI_BitmapButton {

public:

    UI_BitmapPushButton (UI_VisualObject* parent,
                         const UI_Rectangle& shape,
                         UI_ViewID id,
                         UI_BitmapData* enabledBmData = NULL,
                         UI_BitmapData* disabledBmData = NULL);
    // Construct a BitmapPushButton with the given parent, shape and view
    // id.

    const char* ClassName () const {return "UI_BitmapPushButton";};

    UI_WindowClass WindowClass () const;
    
protected:

    ~UI_BitmapPushButton ();

    void _PrivateInitialize ();
    // [YACL internal use only]
    
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    void Press ();
    // [Windows- and OS/2-specific, for internal use only] Override the
    // inherited method.

    void Release ();
    // [Windows- and OS/2-specific, for internal use only]
    
    bool IsRaised ();
    // [Windows- and OS/2-specific, for internal use only]

#elif defined(__X_MOTIF__)
    static void SelectionCallback (struct _WidgetRec*, void *, void *);
    // [X-windows-specific, for internal use only] The callback executed
    // when the button is selected.
    
#endif
};



#endif
