

#ifndef _bmptglbn_h_ /* Mon Sep 18 11:00:31 1995 */
#define _bmptglbn_h_



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// This is a BitmapToggleButton. It behaves just like a ToggleButton, except
// that it displays a bitmap instead of text in the button. It does not use
// its title string.
//
// The Bitmap used by this object is accessible via its Bitmap() method.
// Modifying this Bitmap causes the display to be updated.
//
// As with the plain ToggleButton, the BitmapToggleButton's model is an
// Integer, so the return value of its Model() method must be cast down to a
// reference to a CL_Integer.


#if defined(__GNUC__)
#pragma interface
#endif



#include "base/integer.h"
#include "ui/bmpbtn.h"

class YACL_UI UI_CompositeVObject;
class YACL_UI UI_BitmapToggleButton: public UI_BitmapButton {

public:

    UI_BitmapToggleButton (UI_VisualObject* parent,
                           const UI_Rectangle& shape,
                           UI_ViewID id,
                           UI_BitmapData* enabledBmData = NULL,
                           UI_BitmapData* disabledBmData = NULL);
    // Construct a BitmapToggleButton with the given parent, shape and view
    // id.


    const char* ClassName () const {return "UI_BitmapToggleButton";};


protected:

    ~UI_BitmapToggleButton ();

    UI_WindowClass WindowClass () const;
    
    void _PrivateInitialize ();
    // [YACL internal use only]

    bool _ModelChanged ();
    /// YACL internal use only]
    
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    void Press ();
    // [Windows- and OS/2-specific, for internal use only] Override the
    // inherited method.

    void Release ();
    // [Windows- and OS/2-specific, for internal use only]
    
    bool IsRaised ();
    // [Windows- and OS/2-specific, for internal use only]
    

#elif defined(__X_MOTIF__)
    void _SetupStyle (void* p, short& argn);
    // [X-windows-specific, for internal use only] override the inherited
    // method to set X resources.
    
    static void SelectionCallback (struct _WidgetRec* w,
                                   void* client, void* call);
    // [X-windows-specific, for internal use only] The callback executed
    // when the button is selected.
    
    
#endif
    
};

#endif /* _bmptglbn_h_ */
