




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma implementation
#endif




#include "ui/brush.h"
#include "ui/dsplsurf.h"
#include "ui/applic.h"
#include "ui/composit.h"

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    static short getPatternFromMS(UI_BrushPattern );
#elif defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#    include <string.h>  // Without this, the X includes barf
#    endif
#include <X11/Intrinsic.h>
static long getPatternFromX (const UI_BrushPattern &); 
#endif

UI_Brush::UI_Brush (UI_DrawingSurface* ctxt, const UI_Color& color,
                    UI_BrushPattern ptrn)
: UI_DisplayResource (ctxt)
{
    _color = color;
    _pattern = ptrn;
    _handle = 0;
    _Setup ();
}

// UI_Brush::UI_Brush(const UI_Brush& b)
// : UI_DisplayResource (b._clientCtxt)
// {
//     _pattern = b._pattern;
//     _handle = 0;
//     _Setup ();
// }
// 


UI_Brush::~UI_Brush()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle) {
        SelectObject (_clientCtxt->Handle(), GetStockObject (NULL_BRUSH));
        DeleteObject ((HANDLE) _handle);
    }
#endif
}


void UI_Brush::Pattern (UI_BrushPattern p)
{
    _pattern = p;
    _Setup();
}

void UI_Brush::Color (const UI_Color& newC)
{
    _color = newC;
    _Setup ();
}

const UI_Color& UI_Brush::Color ()
{
    return _color;
}

UI_BrushPattern UI_Brush::Pattern()
{
    return _pattern;
}


UI_BrushDescriptor UI_Brush::Descriptor () const
{
    return UI_BrushDescriptor (_color, _pattern);
}

void UI_Brush::operator= (const UI_BrushDescriptor& b)
{
    _color   = b.color;
    _pattern = b.pattern;
    _Setup();
        
}

void UI_Brush::operator= (const CL_Object&)
{
    NotImplemented ("Operator= (const CL_Object&)");
}

void UI_Brush::_Setup()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle) {
        SelectObject (_clientCtxt->Handle(), GetStockObject (NULL_BRUSH));
        DeleteObject ((HANDLE) _handle);
    }
    short pattern =  getPatternFromMS (_pattern);
    if (pattern == BS_SOLID)
        _handle = CreateSolidBrush (_color.NativeForm());
    else {
        LOGBRUSH logBrush;
        logBrush.lbStyle = pattern;
        logBrush.lbColor = _color.NativeForm();
        logBrush.lbHatch = HS_BDIAGONAL;
        _handle = (UI_ResourceHandle) CreateBrushIndirect (&logBrush);
    }
    SelectObject (_clientCtxt->Handle(), _handle);
#elif defined(__OS2__)
    if (!_clientCtxt)
        return;
    HPS hps = (HPS) _clientCtxt->Handle();
    GpiSetBackColor (hps, _color.NativeForm());
    LONG backMode = BM_LEAVEALONE;
    switch (_pattern) {
    case UIBrush_Hatched:
    case UIBrush_Solid:
        backMode  = BM_OVERPAINT;
        break;
        
    case UIBrush_Hollow:
    default:
        backMode  = BM_LEAVEALONE;
        break;
    };
    GpiSetBackMix (hps, backMode);
#elif defined(__X_MOTIF__)
    if (!_clientCtxt)
        return;
    Display* dpy = YACLApp()->AppDisplay();
    XSetFillStyle  (dpy, _clientCtxt->Handle (), 
                    getPatternFromX (Pattern ()));
#endif
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)

short getPatternFromMS(UI_BrushPattern p)
{
    switch (p) {
    case UIBrush_Hatched:
        return BS_HATCHED;

    case UIBrush_Hollow:
        return BS_HOLLOW;

    case UIBrush_Solid:
        return BS_SOLID;

    default:
        return BS_SOLID;
   } 
}

#elif defined(__X_MOTIF__)

long getPatternFromX (const UI_BrushPattern& p)
{
    switch (p){
        case UIBrush_Hatched:
            return FillTiled;

        case UIBrush_Solid:
            return FillSolid;

        case UIBrush_Hollow:
        default:
            return FillSolid;
    }
}

#endif

