



#ifndef _btngroup_h_ /* Wed Mar 30 08:49:46 1994 */
#define _btngroup_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


/*
  Author: M. A. Sridhar
*/





// A ButtonGroup is a VObjCollection representing a group of toggle
// buttons.  This  class factors out the behavior common between the
// OrButtonGroup and ExOrButtonGroup classes. Application programs need not
// instantiate this class, only its derived classes ToggleButtonGroup and
// ExorToggleButtonGroup.

#if defined(__GNUC__)
#pragma interface
#endif


#include "base/intset.h"

#include "ui/vobjcoll.h"
#include "ui/dsplsurf.h"


#if defined(__OS2__) && defined(__IBMCPP__)
MRESULT EXPENTRY CallBackButtonGroupProc (HWND hWnd, ULONG msg,
                                          MPARAM p1, MPARAM p2);
#endif

class YACL_UI UI_ButtonGroup: public UI_VObjCollection {

public:

    virtual UI_WindowClass WindowClass () const;
    // Override method inherited from {\tt UI_VisualObject}.

    const char* ClassName () const {return "UI_ButtonGroup";};

    
protected:

    UI_ButtonGroup (UI_VObjCollection* parent, const UI_Rectangle& shape,
                    UI_ViewID id = -1);
    // Constructor: creates an empty ButtonGroup as a child of {\tt
    // parent}, with the given shape and view ID.

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ButtonGroup (UI_VObjCollection* parent,  UI_ViewID id,
                    UI_ViewHandle h);
    // Resource-based construction (only under MS-Windows). This assumes
    // that (1) all (and only) the buttons in the group are geometrically
    // contained within the button group box's rectangle,  (2) the
    // contained buttons occur immediately after the group box in the
    // resource file ordering, and (3) the group box has a valid id.
    // Therefore, this does not allow (in particular) for groups within groups.

#endif
    
    ~UI_ButtonGroup ();
    // Protected, to discourage direct destruction. (All YACL
    // VisualObjects are destroyed by the Controller, and must not be
    // deleted by a user program.)

    bool MakeVisualElement ();
    // Create the visual element of the ButtonGroup.

    void MakeInvisible ();
    // Make this ButtonGroup and all its contained buttons invisible. This
    // overrides the inherited virtual method.
    
    void MakeVisible ();
    // Make this ButtonGroup and all its contained buttons visible. This
    // overrides the inherited virtual method.

    void _PrivateInitialize ();
    // [For YACL internal use only.]

    bool _TitleChanged ();
    // [For YACL internal use only.]
    
    bool _FontChanged  ();
    // [For YACL internal use only.]

    
#if defined(__X_YACL__)
    bool HandleEvent (UI_Event* e);
    // Override the inherited method.

    void DrawVisualElement ();
    // Draw the visual representation of the button group.
    
#elif defined(__X_MOTIF__)
private:
    UI_ViewHandle  _frameWidget; // The frame (parent of the button group)
    UI_ViewHandle  _frameLabel;  // Label of the frame

#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)

private:
    bool _GetFocus (UI_Event&);
    // [MS Windows specific, for YACL internal use only]
    
#elif defined(__OS2__)

private:
    bool _GetFocus (UI_Event&);
    // [OS/2 specific, for YACL internal use only]
    
    void _Subclass ();
    // [OS/2-specific, for YACL internal use only]

    PFNWP _oldProc;

#if defined(__IBMCPP__) // IBMCPP only allows _OptLink calling convention
                        // for member functions.  the work around is to
                        // make a global function that is used to call the
                        // class static function...
    static MRESULT ButtonGroupProc (HWND hWnd, ULONG msg,
                                    MPARAM p1, MPARAM p2);
    // [OS/2- and IBM C++-specific, for YACL internal use only]
    
    friend MRESULT EXPENTRY CallBackButtonGroupProc(HWND hWnd, ULONG msg,
                                                    MPARAM p1, MPARAM p2);
    // [OS/2- and IBM C++-specific, for YACL internal use only]
    
#else
    static MRESULT EXPENTRY ButtonGroupProc (HWND hWnd, ULONG msg,
                                             MPARAM p1, MPARAM p2);
    // [OS/2-specific, for YACL internal use only]

#endif
#endif


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
public:
    bool TakeFocus ();
    // [Specific to OS/2 and Windows. YACL internal use only.]

#endif
    
};

                     

#endif /* _btngroup_h_ */
