

#ifndef _chord_h_ /* Thu Jan  5 09:36:32 1995 */
#define _chord_h_



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// This is a GraphicObject representing a chord of an ellipse, bounded by an
// arc and a line. This is a closed figure.
//
// Like the other GraphicObjects, the Chord views its co-ordinate space as
// an abstract space not tied to any particular device. But its {\tt DrawOn}
// and {\tt Fill} methods view its dimension units as pixels.


#if defined(__GNUC__)
#pragma interface
#endif

#include "ui/graphic.h"

class YACL_UI UI_Arc;
class YACL_UI UI_Ellipse;
class YACL_UI UI_LineSegment;

class YACL_UI UI_Chord: public UI_GraphicObject {

public:
    UI_Chord (const UI_Rectangle& boundingRect, long startAngleDeg64,
              long subtendedDeg64);
    // Construct a chord of an ellipse. The Chord is part of the
    // ellipse whose
    // bounding rectangle is {\tt boundingRect}. Its starting point is at an
    // angle {$d$} degrees from the 3-o'clock position of {\tt boundingRect}
    // where $d = {\tt startAngleDeg64} * 64$, and it subtends an angle $s$
    // at the center of the ellipse, where $s = {\tt subtendedDeg64} * 64$.
    // Angles are reckoned counter-clockwise.

    UI_Chord (const UI_Point &p1, const UI_Point &p2, const UI_Point& origin);
    // Construct a chord of an ellipse with the points p1, p2 being the
    // start point and the end point and the origin being the center of
    // the ellipse.    

    UI_Chord ();
    // Construct a chord with zero radii at the origin.
    
    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point (0,0)) const;
    // Draw the chord on the surface {\tt sfc} (overrides inherited
    // method).

    bool Fill (UI_DrawingSurface& sfc) const;
    // Fill the interior of this Chord on the given surface {\tt sfc} with
    // the latter's current brush.
    
    bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);
    // Override method inherited from GraphicObject. The implementation
    // reshapes the ellipse so that its bounding rectangle is the rectangle
    // whose diagonally opposite points are p1 and p2.

    bool MoveTo    (const UI_Point& p);
    // Reposition this chord so that the center of its containing ellipse is
    // the given point. (Overrides inherited method.)

    UI_Point Center () const {return UI_Point (_xOrigin, _yOrigin);};
    // Return the center of the ellipse of this chord.
    
    UI_Rectangle BoundingRectangle() const;
    // Returns the bounding rectangle of the ellipse of which this chord is
    // part.

    UI_PointPair EndPoints () const;
    // Return the two end-points of the Chord.

    UI_HitTest HitTest (const UI_Point& p) const;
    // Hit testing: overrides method inherited from Graphic.
    
    bool IntersectsBoundary (const UI_Rectangle& r) const;
    // Return TRUE of {\tt r} intersects the boundary of this Chord. This
    // overrides the inherited method.
    
    long StartAngle() const;
    // Return the start angle of this Chord, in sixty-fourths of a degree
    // from the 3-o'clock position.

    long SubtendedAngle() const;
    // Return the subtended angle of this Chord, in sixty-fourths of a degree
    // from the 3-o'clock position.

    UI_Ellipse Ellipse() const;
    // Return the ellipse of which this chord is part.

    UI_LineSegment Line () const;
    // Return the line segment joining the two end points.

    UI_Arc Arc () const;
    // Return the arc of this chord.
    
    virtual bool StartAngle (long startAngle64);
    // Set the start angle of this Chord. The parameter is in sixty-fourths of
    // a degree. Return TRUE on success, FALSE on failure (e.g., a
    // pre-change dependent refused permission).

    virtual bool SubtendedAngle (long subtAngle64);
    // Set the subtended angle of this Chord. The parameter is in
    // sixty-fourths of a degree. Return TRUE on success, FALSE on failure
    // (e.g., a pre-change dependent refused permission).

    bool Origin (const UI_Point& p);
    // Move this Chord so that the origin of its ellipse is set to {\tt p}.
    // Return TRUE on success, FALSE if a pre-change dependent refused
    // permission.

    UI_Chord operator+  (const UI_Vector&) const;
    // Return the Chord obtained by translating this Chord by the
    // given vector.

    void operator+= (const UI_Vector& p)
        {*this = *this + p; /* The assignment does notification */ };
    // Move this object by the given vector.


    UI_Chord& operator= (const UI_Chord&);
    // Assignment operator.

    void operator= (const CL_Object& o)
        {if (o.IsA (*this)) *this = (const UI_Chord&) o;};
    // Check {\tt o}'s type, cast it down to a Chord and perform the
    // assignment.
    
    const char* ClassName() const {return "UI_Chord";};

    CL_Object* Clone () const {return new UI_Chord (*this);}
    
protected:
    long   _startAngle; 
    long   _subtAngle;  
    long   _xOrigin;    
    long   _yOrigin;    
    long   _major;      
    long   _minor;
};                            
                              
                              
                              
                              
inline long UI_Chord::StartAngle() const
{
    return _startAngle;
}


inline long UI_Chord::SubtendedAngle() const
{
    return _subtAngle;
}


#endif /* _chord_h_ */
