


/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma implementation
#endif



#include "ui/combobox.h"
#include "ui/strseq.h"
#include "ui/cntroler.h"

#if defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#include "ui/support/x_motif/mocobox.h"
#include <iostream.h> // DEBUG
#endif

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#include <windows.h>
#endif

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#define COMBOBOX_STYLE  WS_CHILD | WS_VISIBLE \
        | WS_GROUP | WS_VSCROLL | WS_TABSTOP  | \
        CBS_AUTOHSCROLL
#elif defined(__OS2__)
#define COMBOBOX_STYLE WS_VISIBLE | ES_ANY | WS_TABSTOP
#endif


typedef CL_Binding0<UI_ComboBox> ComboBoxBind;

#if defined(__GNUC__)
template class CL_Binding0<UI_ComboBox>;
#elif defined(_MSC_VER)
template CL_Binding0<UI_ComboBox>;
#endif



UI_ComboBox::UI_ComboBox
    (UI_VisualObject* p, const UI_Rectangle& shape, UI_ViewID id,
     short dropHt, bool editable)
: UI_StringViewSingleSel (p, shape, id), _dropDownHeight (dropHt)
{   
    _editable = editable;
    _limit    = 255;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style = COMBOBOX_STYLE | (editable ? CBS_DROPDOWN : CBS_DROPDOWNLIST);
    UI_Rectangle r = _shape;
    r.AddToHeight (dropHt);
    _SetShapeRectangle (r);
#elif defined(__OS2__)
    _style = WS_VISIBLE | (editable ? CBS_DROPDOWN : CBS_DROPDOWNLIST);
    // OS/2 combo boxes always have a default height of the edit portion,
    // and the height specification in the WinCreateWindow call (i.e. the
    // height in the shape rectangle) is the total height including the
    // drop-down list height. So:
    UI_Rectangle r = _shape;
    r.AddToHeight (dropHt - shape.Height());
    _SetShapeRectangle (r);
#endif
    ComboBoxBind bind (this, &UI_ComboBox::_EditStringChanged);
    _editString.AddDependent (bind);
}




#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_ComboBox::UI_ComboBox
    (UI_CompositeVObject* p, UI_ViewID id, UI_ViewHandle h)
: UI_StringViewSingleSel (p, id, h)
{
    _model = new UI_StringSequence;
    ((UI_StringSequence*) _model)->AddClient (this);
    ComboBoxBind bind (this, &UI_ComboBox::_EditStringChanged);
    _editString.AddDependent (bind);
}
#endif


void  UI_ComboBox::ShowDropDown ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle)
        SendMessage (_handle, CB_SHOWDROPDOWN, 1, 0);
#elif defined(__OS2__)
    if (_handle)
        WinSendMsg (_handle, CBM_SHOWLIST, (MPARAM) 1, 0);
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XmComboBoxShowList(_xwidget);
#endif
}


void  UI_ComboBox::HideDropDown ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle)
        SendMessage (_handle, CB_SHOWDROPDOWN, 0, 0);
#elif defined(__OS2__)
    if (_handle)
        WinSendMsg (_handle, CBM_SHOWLIST, 0, 0);
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XmComboBoxHideList(_xwidget);
#endif
}

#if defined(__X_MOTIF__)
void UI_ComboBox::SelectionCallback (Widget , void* client,
                                     void* call)
{
    UI_ComboBox* box = (UI_ComboBox *) client;
    XmComboBoxSelectionCallbackStruct* cb =
        (XmComboBoxSelectionCallbackStruct*) call;
    UI_Event evt (Event_Select, box, box);
    _Controller->DispatchEvent (&evt);
}

bool UI_ComboBox::MakeVisualElement ()
{
    // For the UI_ComboBox _list and _xwidget are the same
    // StringView uses both variables.
    bool retc = UI_SimpleVObject::MakeVisualElement();
    _list = _xwidget;
    XtVaSetValues (XmComboBoxGetEditWidget(_list), XmNheight,
                   _shape.Height(), 0);
    XtVaSetValues (XmComboBoxGetLabelWidget(_list), XmNheight,
                   _shape.Height(), 0);
    XtVaSetValues (XmComboBoxGetListWidget(_list), XmNheight,
                   _dropDownHeight, 0);
    XtAddCallback (_xwidget, XmNselectionCallback, 
                   &UI_ComboBox::SelectionCallback, (XtPointer) this);
    return retc;
}

void UI_ComboBox::_AddModelStrings ()
{
    UI_StringSequence& theModel = *(UI_StringSequence*) _model;
    long n = theModel.Size();
    if (n && _xwidget) {
        for (long i = 0; i < n; i++) {
            XmString  xs = XmStringCreate
                ((char*) theModel[i].AsPtr(), XmSTRING_DEFAULT_CHARSET); 
            XmComboBoxAddItem (_xwidget, xs, 0);
            XmStringFree (xs);
        }
    }
}

void UI_ComboBox::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;
    UI_SimpleVObject::_SetupStyle (p, argn);
    XtSetArg (arg[argn], XmNshowLabel, False); argn++;
    XtSetArg (arg[argn], XmNeditable, _editable ? True : False); argn++;
}
#endif






#if defined(__X_MOTIF__)
bool UI_ComboBox::_ModelChanged ()
{
    if (_xwidget)
        XmComboBoxDeleteAllItems (_xwidget);
    _AddModelStrings();
    _UpdateSelection();
    return TRUE;
    return UI_StringViewSingleSel::_ModelChanged();
}
#endif


bool UI_ComboBox::IsDropDownShowing() const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return _handle ? SendMessage (_handle, CB_GETDROPPEDSTATE, 0, 0) : FALSE;
#elif defined(__OS2__)
    if (!_handle)
        return FALSE;
    return WinSendMsg (_handle, CBM_ISLISTSHOWING, 0, 0) ? TRUE : FALSE;
#elif defined(__X_MOTIF__)
    return _xwidget && XmComboBoxIsDropdownVisible (_xwidget)
        ? TRUE : FALSE;
#endif
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
CL_String UI_ComboBox::EditContent ()
{
    UI_ViewHandle h = ViewHandle ();
    if (!h)
        return "";
    if (_editable) {
        char* data   = NULL;
        short length = 0;
        length = GetWindowTextLength (h) + 1;
        if (length) {
            data = new char [length];
            if (data)
                GetWindowText (h, data, length);
        }
        CL_String ret = data ? data : "";
        if (data)
            delete data;
        return ret;
    }
    // Not editable (i.e., CBS_DROPDOWNLIST)
    long index = (long) SendMessage (h, CB_GETCURSEL, 0, 0);
    UI_StringSequence& theModel = *(UI_StringSequence*) _model;
    if (index >= 0 && index < theModel.Size())
        return theModel (index);
    return "";
        
}

#elif defined(__OS2__)
CL_String UI_ComboBox::EditContent ()
{
    UI_ViewHandle h = ViewHandle ();
    if (!h)
        return "";
    long n = WinQueryWindowTextLength (h);
    char* buf = new char[n+1];
    if (!buf)
        return ""; // No memory
    WinQueryWindowText (h,  n+1, buf);
    CL_String ret (buf);
    delete buf;
    return ret;
}
#elif defined(__X_MOTIF__)
CL_String UI_ComboBox::EditContent ()
{
    Widget widget = ViewHandle();
    if (widget == NULL)
        return "";
    char* data = XmComboBoxGetString (widget);
    CL_String ret(data);
    XtFree(data);
    return ret;
}
#elif defined(__X_YACL__)
CL_String UI_ComboBox::EditContent ()
{
    return ""; // For now
}
#endif

CL_String& UI_ComboBox::EditString ()
{
    UI_ViewHandle h = ViewHandle();
    if (!h)
        return _editString;
    ComboBoxBind bind (this, &UI_ComboBox::_EditStringChanged);
    _editString.RemoveDependent (bind);
    _editString = EditContent   ();
    _editString.AddDependent (bind);
    return _editString;
}



void UI_ComboBox::SetLengthLimit (short limit)
{
    _limit = limit;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle)
        SendMessage (_handle, CB_LIMITTEXT, limit, 0);
#elif defined(__OS2__)
    if (_handle)
        WinSendMsg  (_handle, EM_SETTEXTLIMIT, MPFROM2SHORT(limit, 0), 0);
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XmComboBoxSetMaxLength(_xwidget, limit);
#endif
}



long  UI_ComboBox::TopIndex () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return (_handle) ? SendMessage (_handle, CB_GETCURSEL, 0, 0)
        : -1;
#elif defined(__OS2__)
    return _handle ? (long) WinSendMsg (_handle, LM_QUERYTOPINDEX, 0, 0) : -1;
#elif defined(__X_MOTIF__)
    if(_xwidget) {
      int pos = 0;
      XtVaGetValues(_xwidget, XmNtopItemPosition, &pos, NULL);
      return pos-1;
    } else {
      return -1;
    }
#endif
}


short UI_ComboBox::VisibleCount () const
{
    return 1; // Can't really do this. Can we do better at all?
}


void  UI_ComboBox::ScrollTo (long index)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle)
        SendMessage (_handle, CB_SETCURSEL, index, 0);
#elif defined(__OS2__)
    if (_handle)
        WinSendMsg (_handle, LM_SETTOPINDEX, (MPARAM) index, 0);
#elif defined(__X_MOTIF__)
    // have to figure out how (XmNtopItemPosition is read-only)
#endif
}





void UI_ComboBox::ItemInserted (long i)
{
    CL_String s = (*(UI_StringSequence*) _model) [i+1];

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle)
        SendMessage (_handle, CB_INSERTSTRING, i+1, (long)(const char*)s);
#elif defined(__OS2__)
    if (_handle)
        WinInsertLboxItem (_handle, i, s.AsPtr());
#elif defined(__X_MOTIF__)
    if(_xwidget) {
        XmString  xs = XmStringCreate ((char*) s.AsPtr(),
                                        XmSTRING_DEFAULT_CHARSET); 
        XmComboBoxAddItem (_xwidget, xs, i + 1);
        XmStringFree (xs);
     }
#endif
    _UpdateSelection ();
}



void UI_ComboBox::ItemRemoved (long i)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle)
        SendMessage (_handle, CB_DELETESTRING, i, 0L);
#elif defined(__OS2__)
    if (_handle)
        WinDeleteLboxItem (_handle, i);
#elif defined(__X_MOTIF__)
    if(_xwidget)
        XmComboBoxDeletePos(_xwidget, i + 1);
#endif
    _UpdateSelection ();
}



void UI_ComboBox::ItemChanged (long i)
{
    CL_String s = (*(UI_StringSequence*)_model)[i];
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SendMessage (_handle, WM_SETREDRAW,  FALSE, 0L);
    SendMessage (_handle, CB_DELETESTRING, i, 0L);
    SendMessage (_handle, CB_INSERTSTRING, i, (long) s.AsPtr());
    SendMessage (_handle, WM_SETREDRAW, TRUE, 0L);
#elif defined(__OS2__)
    if (_handle) {
        WinDeleteLboxItem (_handle, i);
        WinInsertLboxItem (_handle, i, s.AsPtr());
    }
#elif defined(__X_MOTIF__)
    if(_xwidget) {
        XmComboBoxDeletePos(_xwidget, i + 1);
        XmString  xs = XmStringCreate ((char*) s.AsPtr(),
                                        XmSTRING_DEFAULT_CHARSET); 
        XmComboBoxAddItem (_xwidget, xs, i + 1);
        XmStringFree (xs);
     }
#endif
}


void UI_ComboBox::ModelEmptied ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle)
        SendMessage (_handle, CB_RESETCONTENT, 0,     0);
#elif defined(__OS2__)
    if (_handle)
        WinSendMsg (_handle, LM_DELETEALL, 0, 0);
#elif defined(__X_MOTIF__)
    if(_xwidget)
        XmComboBoxDeleteAllItems(_xwidget);
#endif    
}




#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
// This code is temporarily commented out until I figure out how to use it
// correctly.
// class BoxHandles {
// 
// public:
//     BoxHandles       (HWND comboBoxHandle);
//     HWND EditHandle  () const {return _editHandle;};
//     HWND ListHandle  () const {return _listHandle;};
// 
// protected:
//     HWND _editHandle;
//     HWND _listHandle;
//     static BOOL CALLBACK YACL_UI EnumCallback (HWND hwnd, LPARAM param);
// };
// 
// 
// BoxHandles::BoxHandles (HWND comboBoxHandle)
// {
//     _editHandle = _listHandle = 0;
//     EnumChildWindows (GetParent(comboBoxHandle),
//                       (FARPROC) EnumCallback, (long) this);
// }
// 
// BOOL CALLBACK YACL_UI BoxHandles::EnumCallback (HWND hwnd, LPARAM param)
// {
//     if (!hwnd)
//         return FALSE;
//     char buffer[30];
//     if ((GetClassName (hwnd, buffer, 30)) == 0)
//         return FALSE;
//     MessageBox (NULL, buffer, "class name", MB_ICONEXCLAMATION);
//     return TRUE;
// }

#endif

void UI_ComboBox::_PrivateInitialize ()
{
    UI_SimpleVObject::_PrivateInitialize ();
    UI_StringSequence& theModel = *(UI_StringSequence*) _model;
    theModel.AddClient (this);
    long n = theModel.Size();
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (n) {
        SendMessage (_handle, WM_SETREDRAW,    FALSE, 0);
        SendMessage (_handle, CB_RESETCONTENT, 0,     0);
        for (long i = 0; i < n; i++) {
            SendMessage (_handle, CB_ADDSTRING, 0,
                         (long) theModel[i].AsPtr());
        }
        SendMessage ((HWND)(long)_handle, WM_SETREDRAW, TRUE, 0L);
    }
//     BoxHandles handles (_handle);
//     HWND hEdit = handles.EditHandle ();
//     HWND hList = handles.ListHandle ();
//     if (hEdit)
//         MoveWindow (hEdit, _shape.Left(), _shape.Top(), _shape.Width(),
//                     _shape.Height(), TRUE);
//     if (hList) {
//         RECT rect;
//         GetClientRect (hEdit, &rect);
//         MoveWindow (hEdit, rect.left, rect.top, rect.right - rect.left,
//                     _dropDownHeight, TRUE);
//     }
#elif defined(__OS2__)
//     HWND listWnd = WinWindowFromID (_handle, CBID_LIST);
//     HWND editWnd = WinWindowFromID (_handle, CBID_EDIT);
//     RECTL rect;
//         WinQueryWindowRect (editWnd, &rect);
//     if (listWnd) {
//         WinQueryWindowRect (listWnd, &rect);
//         rect.yTop = rect.yBottom + _dropDownHeight - 1;
//         WinSetWindowPos (listWnd, 0, rect.xLeft, rect.yBottom,
//                          rect.xRight - rect.xLeft + 1, _dropDownHeight,
//                          SWP_SIZE
//                          );
//     }
    WinSendMsg (_handle, LM_DELETEALL, 0, 0);
    for (long i = 0; i < n; i++)
        WinInsertLboxItem (_handle, LIT_END, theModel[i].AsPtr());
#elif defined(__X_MOTIF__)
    if (n) {
        for (long i = 0; i < n; i++) {
            XmString  xs = XmStringCreate ((char*) theModel[i].AsPtr(),
                                           XmSTRING_DEFAULT_CHARSET); 
            XmComboBoxAddItem (_xwidget, xs, 0);
            XmStringFree (xs);
        }
    }
#endif
    if (_selection != -1)
        _SelectionChanged (); // Force update
}



UI_WindowClass UI_ComboBox::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return "combobox";
#elif defined(__OS2__)
    return WC_COMBOBOX;
#elif defined(__X_MOTIF__)
    return xmComboBoxWidgetClass;
#endif
}


bool UI_ComboBox::Select ()
{
    // Called in response to Event_Select generated when the user changes a
    // selection
    _UpdateSelection ();
    return FALSE; // So that the parent gets a chance to handle this event
}





void UI_ComboBox::_UpdateSelection ()
{
    ComboBoxBind bind (this, &UI_ComboBox::_SelectionChanged);
    _selection.RemoveDependent (bind);
    ComboBoxBind ebind (this, &UI_ComboBox::_EditStringChanged);
    _editString.RemoveDependent (ebind);
    CL_String editContents;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    long pos = SendMessage (_handle, CB_GETCURSEL, 0, 0);
    if (pos == LB_ERR)
        pos = -1;
    _selection = pos;
#elif defined(__OS2__)
    long pos = (long) WinSendMsg (_handle, LM_QUERYSELECTION,
                                  (MPARAM) -1, 0);
    if (pos == LIT_NONE)
        pos = -1;
    _selection = pos;
#elif defined(__X_MOTIF__)
    _selection = XmComboBoxGetSelectedPos (_xwidget) - 1;
    // The returned index is 1-origin-indexed, so subtract 1.
#elif defined(__X_YACL__)
    // Nothing yet
#else
    if (_editable)
        _editString = EditContent ();
    else if (pos >= 0)
        _editString =  (*(UI_StringSequence*) _model) [pos];
    else
        _editString = "";
#endif
    _selection.AddDependent (bind);
    _editString.AddDependent (ebind);
}




bool UI_ComboBox::_SelectionChanged ()
{
    if (!ViewHandle())
        return TRUE;
    UI_StringSequence& theModel = *(UI_StringSequence*) _model;
    if (_selection < 0 || _selection >= theModel.Size()) {
        ComboBoxBind bind (this, &UI_ComboBox::_SelectionChanged);
        _selection.RemoveDependent (bind);
        _selection = -1; 
        _selection.AddDependent (bind);
        return TRUE;
    }
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SendMessage (_handle, CB_SETCURSEL, _selection, 0);
#elif defined(__OS2__)
    WinSendMsg (_handle, LM_SELECTITEM, (MPARAM) _selection.Value(),
                (MPARAM) TRUE);
#elif defined(__X_MOTIF__)
    XmComboBoxSelectPos(_xwidget, _selection.Value() + 1, FALSE);
#endif
    return TRUE;
}


bool UI_ComboBox::_EditStringChanged ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SetWindowText (_handle, _editString.AsPtr());
    SendMessage   (_handle, CB_SETEDITSEL, 0,
                   MAKELONG (0, _editString.Size()-1));
#elif defined(__OS2__)
    WinSetWindowText (_handle, _editString.AsPtr());
#elif defined(__X_MOTIF__)
    if(_xwidget) {
        if (_editable)
            XmComboBoxSetString(_xwidget, (char*) _editString.AsPtr());
        else {
            long ndex = ((CL_StringSequence*) _model)->LinearSearch
                (_editString);
            if (ndex >= 0)
                _selection = ndex;
        }
    }
#endif
    return TRUE;
}



void UI_ComboBox::MakeVisible ()
{
    // This method is overridden because, under Motif, the StringView has a
    // frame which is not used by the combobox implementation. SO the
    // ComboBox cannot use the method inherited from StringView.
    UI_SimpleVObject::MakeVisible();
}

void UI_ComboBox::MakeInvisible ()
{
    // This method is overridden because, under Motif, the StringView has a
    // frame which is not used by the combobox implementation. SO the
    // ComboBox cannot use the method inherited from StringView.
    UI_SimpleVObject::MakeInvisible();
}

bool UI_ComboBox::Enable ()
{
    // This method is overridden because, under Motif, the StringView has a
    // frame which is not used by the combobox implementation. SO the
    // ComboBox cannot use the method inherited from StringView.
    return UI_SimpleVObject::Enable();
}

bool UI_ComboBox::Disable ()
{
    // This method is overridden because, under Motif, the StringView has a
    // frame which is not used by the combobox implementation. SO the
    // ComboBox cannot use the method inherited from StringView.
    return UI_SimpleVObject::Disable();
}

