


#ifndef _combobox_h_ /* Wed Feb 22 22:18:00 1995 */
#define _combobox_h_



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma interface
#endif

#include "ui/strview.h"

// This is a ComboBox, a combination StringEditor and StringView in which
// the StringView part functions as a drop-down list. A ComboBox is said to
// be {\it editable\/} if the user can type in a string in the StringEditor
// that is different from any of the strings in the drop-down list. If it is
// editable, the ComboBox displays the current selection in an  editable
// window; otherwise, it displays the current selection in a label.
//
// Under Motif, this class uses the GPL'ed combobox implementation by Harald
// Albrecht. Thanks to Holger Pfaff for the port.



class YACL_UI UI_ComboBox: public UI_StringViewSingleSel {

public:
    UI_ComboBox (UI_VisualObject* parent, const UI_Rectangle& shape,
                 UI_ViewID id, short dropDownHeight, bool editable = FALSE);
    // Construct a ComboBox as a child of {\tt parent}, with the given shape
    // and view id. The shape specified is the shape of the edit portion of
    // the ComboBox. The fourth parameter is the height (in pixels) of the
    // dropdown list when shown, and the last parameter determines whether
    // the ComboBox is editable.
    //
    // Caveat: The sizes of the edit and list portions can be set
    // independently only under X/Motif. On other platforms, the edit box
    // has a defaullt shape, and the total height of the combobox rectangle
    // (including the dropdown) is the sum of {\tt shape.Height()} and {\tt
    // dropDownHeight}.

    CL_String& EditString ();
    // Return the content of the edit string of the ComboBox. If this
    // ComboBox is editable, then this string is the one typed by the user,
    // and therefore is not necessarily a part of the model. If the
    // application modifies this  String, the content of the edit box is
    // correspondingly changed.

    void SetLengthLimit (short n);
    // Limit user type-in to the edit string to $n$ characters.
    
    virtual void  ShowDropDown ();
    // Show the drop-down list, if not currently shown.
    
    virtual void  HideDropDown ();
    // Hide the drop-down list, if not currently hidden.

    bool IsDropDownShowing() const;
    // Is the drop-down list currently showing?
    
    virtual long  TopIndex () const;
    // Return the index of the topmost visible string in the view.

    virtual short VisibleCount () const;
    // Return the number of visible strings. [Not yet implemented under
    // OS/2.]
    
    virtual void  ScrollTo (long index);
    // Scroll the view so that the String at the given index is at the top.
    
    
    // ---------------- Overridden SimpleVObject methods -------------

    virtual UI_WindowClass WindowClass () const;

    void MakeVisible ();

    void MakeInvisible ();

    bool Enable ();

    bool Disable ();
    
    // ---------------- Overridden basic methods ---------------------
    
    const char* ClassName () const { return "UI_ComboBox";};


    
protected:

    virtual void _UpdateSelection ();
    // Called by {\tt ItemInserted} and {\tt ItemRemoved} to tell us
    // to update our selection.


    virtual void ItemInserted (long pos);
    //  [YACL internal use only] Called by the model to notify this view
    //  that the model just added a new item immediately  after the given
    //  position.

    virtual void ItemRemoved (long);
    // [YACL internal use only]

    virtual void ItemChanged (long);
    // [YACL internal use only]

    virtual void ModelEmptied ();
    // [YACL internal use only]
    
    virtual bool _SelectionChanged ();
    // [YACL internal use only] Called by the selection when it is modified
    // by the application.
    
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ComboBox (UI_CompositeVObject* parent, UI_ViewID id,
                 UI_ViewHandle h);
    // [MS-Windows-specific] Resource-based construction.

#endif
#if defined(__X_MOTIF__)

    bool MakeVisualElement();

    bool _ModelChanged();

    void _AddModelStrings();

    void _SetupStyle (void* arg, short& argn);
    // Motif-specific; for YACL internal use only.

    static void SelectionCallback (struct _WidgetRec*, void*, void*);
    // [X-windows-specific, for internal use only] The callback executed
    // when an item is selected.

    
#endif


    void  _PrivateInitialize ();
    // [YACL internal use only]

    bool Select ();
    // [YACL internal use only] Called when the user makes a change in the
    // selection.

    virtual bool _EditStringChanged ();
    // [YACL internal use only] Called when the application makes a change
    // in the edit string, via a String method applied to the return value
    // of the {\tt EditString} method.

    CL_String EditContent ();
    // Return the string in the edit portion of the combo box.
    
protected:
    bool        _editable;
    CL_String   _editString;
    short       _limit;
    short       _dropDownHeight;
};

#endif /* _combobox_h_ */
