


/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/dateedit.h"

static const char* DateFormat = "xx/xx/19xx";
static const short DateFormatSize = 10; // # chars in DateFormat

UI_DateEditor::UI_DateEditor (UI_VisualObject* parent,
                              const UI_Rectangle& shape,
                              UI_ViewID id)
: UI_StringEditor (parent, shape, id)
{
    _SetModelValue (CL_String (DateFormat));
    _insertPosition = -1;
}



bool UI_DateEditor::FilterChar (short& key)
{
    if (Selection().Length() > 0)
        return FALSE; // Disallow destroying a selection
    CL_Integer& pos = InsertionPosition();
    if (pos >= DateFormatSize || pos == 2 || pos == 5)
        return FALSE; // Disallow appending or changing the slashes
    bool retVal = (key >= 32 && key <= 127)
        ? (key >= '0' && key <= '9') : TRUE;
    // If it's printable, it must be a digit. Otherwise we return FALSE.
    if (!retVal)
        return FALSE;
    CL_String& model = (CL_String&)  Model();
    short n =  model.Size();
    if (n >= DateFormatSize && pos >= 0 && pos < n) {
        short savePos = pos;
        model.Delete (pos, 1); // Delete the character to the right
        pos = savePos;         // Needed because the above change in model
                               // can alter the cursor position
    }
    return TRUE;
}

void UI_DateEditor::Update ()
{
    // Update the cursor position
    CL_Integer& pos = InsertionPosition();
    short savePos = pos;
    CL_String&  model = (CL_String&)  Model();
    short n = model.Size();
    if (n >= DateFormatSize && savePos >= 0 && savePos < n) {
        if (savePos < DateFormatSize && (savePos == 2 || savePos == 5))
            pos++; // Advance past the slash
    }
}

void UI_DateEditor::_PrivateInitialize ()
{
    UI_StringEditor::_PrivateInitialize ();
    _insertPos = 0; // Force cursor to be at left end
}

