

#ifndef _dateedit_h_ /* Tue Aug  8 21:02:45 1995 */
#define _dateedit_h_




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




// DateEditor is  derived  from StringEditor and intended for editing
// a date in xx/xx/19xx format. Currently it doesn't really check that a
// valid date is typed in; it only ensures that digits are typed in, and
// advances the cursor appropriately.
//
// In the current version, the DateEditor's model is a String, the same as the
// StringEditor's. A later YACL release might change the model to be a
// CL_Date.


#include "ui/stred.h"

class YACL_UI UI_DateEditor: public UI_StringEditor {

public:
    UI_DateEditor (UI_VisualObject* parent, const UI_Rectangle& shape,
                   UI_ViewID id);
    // Constructor: Create a DateEditor with given parent, shape and view
    // id.

    
protected:
    virtual bool FilterChar (short& key);
    // Override the inherited method.

    virtual void Update ();
    // Override the inherited method.

    virtual bool PermitDelete ()
        {return FALSE;}
    // Override the inherited method. The implementation returns FALSE to
    // disallow deletion.

    void _PrivateInitialize();
    // Override the inherited method.
    
private:
    short     _insertPosition;

};

#endif /* _dateedit_h_ */
