



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





// Authors: R. Sampath
//          M. A. Sridhar

#if defined(__GNUC__)
#pragma implementation
#endif


#include "ui/dsinmem.h"
#include "ui/cntroler.h"
#include "ui/bitmap.h"
#include "ui/dsplsurf.h"
#include "ui/visualob.h"
#include "ui/color.h"
#include "ui/pen.h"
#include "ui/brush.h"
#include "ui/composit.h"

#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
#    if defined(_MSC_VER)
#        include <memory.h>
#    else
#        include <mem.h>
#    endif
#elif defined (__OS2__)
#    if defined(__WATCOMC__)
#        include <mem.h>
#    else
#        include <memory.h>
#    endif
#elif defined (__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#    include <string.h>  // Without this, the X includes barf
#    endif
#    include <X11/Intrinsic.h>
#    include <X11/StringDefs.h>
#endif



#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding0<UI_DwgSurfaceInMemory>;
#elif defined(_MSC_VER)
template CL_Binding0<UI_DwgSurfaceInMemory>;
#endif

typedef CL_Binding0<UI_DwgSurfaceInMemory> DSBind;




UI_DwgSurfaceInMemory::UI_DwgSurfaceInMemory (long width, long height)
    : _width (width), _height (height)
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    HDC screenDC = GetDC (NULL);
    _handle = CreateCompatibleDC (screenDC);
    _hbm    = CreateCompatibleBitmap (screenDC, _width, _height);
    SelectObject (_handle, _hbm);
    ReleaseDC (NULL, screenDC);
    
#elif defined (__OS2__)
    HAB     hab = YACLApp()->Controller().AnchorBlockHandle();
    SIZEL  sizl = {0, 0};   
    DEVOPENSTRUC dop = {0L, "DISPLAY", NULL, 0L, 0L, 0L, 0L, 0L, 0L};
    _hdc = DevOpenDC (hab, OD_MEMORY, "*", 2L, (PDEVOPENDATA) &dop,
                      NULLHANDLE);
    if (!_hdc)
        UI_Application::PMError();

    // In the following calls to DevQueryCaps, I use local variables as
    // the last parameter rather than instance variables because GNU C++
    // seems to have some obscure problems with taking instance variable
    // addresses.
    long hresPPM, vresPPM;
    DevQueryCaps (_hdc, CAPS_HORIZONTAL_RESOLUTION, 1L, &hresPPM);
    DevQueryCaps (_hdc, CAPS_VERTICAL_RESOLUTION,   1L, &vresPPM);
    _horzPPM = hresPPM;
    _vertPPM = vresPPM;

//     sizl.cx = _width;
//     sizl.cy = _height;
    _handle = GpiCreatePS (hab, _hdc, &sizl, PU_PELS | GPIF_DEFAULT
                           | GPIT_MICRO | GPIA_ASSOC);
    GpiCreateLogColorTable (_handle, 0, LCOLF_RGB, 0, 0, (PLONG)NULL);
    if (!_handle)
        UI_Application::PMError();
    BITMAPINFOHEADER2 bmp;
    memset (&bmp, 0, sizeof (BITMAPINFOHEADER2));
    long colorPlanes, colorBitCount;

    DevQueryCaps (_hdc, CAPS_COLOR_PLANES, 1L, &colorPlanes);
    DevQueryCaps (_hdc, CAPS_COLOR_BITCOUNT, 1L, &colorBitCount);
    bmp.cbFix     = sizeof (BITMAPINFOHEADER2);
    bmp.cx        = _width;
    bmp.cy        = _height;
    bmp.cPlanes   = colorPlanes;
    bmp.cBitCount = colorBitCount;
    
    _hbm       = GpiCreateBitmap (_handle, &bmp, 0L, NULL, NULL);
    if (!_hbm)
        UI_Application::PMError();
    GpiSetBitmap (_handle, _hbm);
    
#elif defined (__X_MOTIF__) || defined(__X_YACL__)
    UI_Application* app = YACLApp();
    if (!app) {
        CL_Error::Warning ("UI_DwgSurfaceInMemory constructor: NULL "
                           "Application!");
        return;
    }
    Display *dpy        = app->AppDisplay();
    UI_CompositeVObject* o = app->MainWindow();
    if (!o) {
        CL_Error::Warning ("UI_DwgSurfaceInMemory constructor: No main "
                           "window!");
        return;
    }
#if defined(__X_YACL__)
    Drawable   d      = o->ViewHandle();
#else // X_MOTIF
    Drawable   d      = XtWindow (o->ShellHandle());
#endif
    short screen_num  = DefaultScreen (dpy);
    int depth         = DefaultDepth (dpy, screen_num);
    _pixmap    = XCreatePixmap (dpy, d, _width, _height, depth);
    XGCValues xvalues;
    _handle    = XCreateGC (dpy, d, 0, &xvalues);

#endif
    _brush  = new UI_Brush (this, UIColor_White, UIBrush_Solid);
    _pen    = new UI_Pen   (this);
    _font   = new UI_Font (this);
    DSBind pre  (this, (DSBind::MethodPtr)
                 &UI_DwgSurfaceInMemory::_FontWillChange);
    _font->AddPreChangeDependent (pre);
    DSBind post (this, (DSBind::MethodPtr)
                 &UI_DwgSurfaceInMemory::_FontChanged);
    _font->AddDependent (post);
}



UI_DwgSurfaceInMemory::~UI_DwgSurfaceInMemory ()
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    SelectObject (_handle, (HPEN) NULL_PEN);
    SelectObject (_handle, (HBRUSH) NULL_BRUSH);
    DeleteDC (_handle);
    DeleteObject (_hbm);
#elif defined (__OS2__)
    GpiDestroyPS (_handle);
    DevCloseDC (_hdc);
    GpiDeleteBitmap (_hbm);
#elif defined (__X_MOTIF__) || defined(__X_YACL__)
    Display *dpy      = YACLApp()->AppDisplay();
    XFreePixmap (dpy, _pixmap);
#endif
    if (_pen)
        delete _pen;
    if (_brush)
        delete _brush;
    if (_font) {
        DSBind pre  (this, (DSBind::MethodPtr)
                     &UI_DwgSurfaceInMemory::_FontWillChange);
        _font->RemovePreChangeDependent (pre);
        DSBind post (this, (DSBind::MethodPtr)
                     &UI_DwgSurfaceInMemory::_FontChanged);
        _font->RemoveDependent (post);
        delete _font;
    }
}


UI_Rectangle UI_DwgSurfaceInMemory::DrawingAreaInMM() const
{
    return UI_DrawingSurface::DrawingAreaInMM();
}


double UI_DwgSurfaceInMemory::VertPixelsPerMM() const
{
    return _horzPPM / 1000.0;
}


double UI_DwgSurfaceInMemory::HorzPixelsPerMM() const
{
    return _vertPPM / 1000.0;
}



void UI_DwgSurfaceInMemory::CopyTo (UI_DisplaySurface& sfc, const
                                    UI_Point& p)
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    BitBlt (sfc.Handle(), p.XCoord(), p.YCoord(), sfc.DrawingArea().Width(),
            sfc.DrawingArea().Height(), _handle, 0, 0, SRCCOPY);
    
#elif defined (__OS2__)
    long h = sfc.DrawingArea().Height();
    POINTL destPt;
    destPt.x = p.XCoord();
    destPt.y = h - p.YCoord () - _height;
    WinDrawBitmap (sfc.Handle(), _hbm, NULL, &destPt, CLR_NEUTRAL,
                   CLR_BACKGROUND, DBM_NORMAL);
#elif defined (__X_MOTIF__) || defined(__X_YACL__)
    Display *dpy      = YACLApp()->AppDisplay();
    UI_Rectangle rec = sfc.DrawingArea();
    short w = minl (_width,  rec.Width()  - p.XCoord());
    short h = minl (_height, rec.Height() - p.YCoord());
    XCopyArea (dpy, _pixmap, sfc._Drawable(), sfc.Handle(),
               0, 0, w, h, p.XCoord(), p.YCoord());
#endif
}

