



#ifndef _ellipse_h_ /* Sat Oct 29 09:47:06 1994 */
#define _ellipse_h_



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/point.h"


// This class represents an ellipse whose major and minor axes are parallel
// to the co-ordinate axes. It is derived from GraphicObject and
// overrides many of the inherited methods with implementations specific to
// the ellipse.
//
// Like the other GraphicObjects, the Ellipse views its co-ordinate space as
// an abstract space not tied to any particular device. But its {\tt DrawOn}
// and {\tt Fill} methods view its dimension units as pixels.

class YACL_UI UI_Ellipse: public UI_GraphicObject {

public:
    UI_Ellipse (long major_axis, long minor_axis, UI_Point origin =
                UI_Point (0, 0));
    // Create an ellipse with given origin and given major and minor axes.
    // If the two axes are equal, the result is a circle with given
    // diameter.

    UI_Ellipse (const UI_Ellipse&);
    // Copy constructor.
    
    UI_Ellipse (const UI_Rectangle&);
    // Construct an ellipse whose bounding box is the given rectangle.
    
    UI_Ellipse ();
    // Create an ellipse at position (0, 0) of size 0.

    UI_Point Center () const {return _origin;};
    // Return the center of the ellipse.

    long MajorAxis () const { return _majorAxis;};
    // Return the length of the major axis.
    
    long MinorAxis () const { return _minorAxis;};
    // Return the length of the minor axis.
   
    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point (0,0)) const;
    // Draw the ellipse on the surface {\tt sfc}
    // translated with respect to {\tt p} (i.e., treating {\tt p} as the
    // origin). This overrides the inherited method.

    bool Fill   (UI_DrawingSurface& s) const;
    // Fill the interior of this ellipse on the DrawingSurface {\tt s} with
    // {\tt s}'s current brush.
    
    bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);
    // Override method inherited from GraphicObject. The implementation
    // reshapes the ellipse so that its bounding rectangle is the rectangle
    // whose diagonally opposite points are {\tt p1} and {\tt p2}.

    bool MoveTo (const UI_Point& p);
    // Overrides inherited virtual method.
    // Repositions this ellipse so that its center is at the given point.
    // Returns FALSE if a pre-change dependent refused permission
    // and TRUE otherwise.
    
    UI_HitTest HitTest (const UI_Point& p) const;
    // Hit testing: overrides method inherited from Graphic. The return
    // value indicates whether {\tt p} is inside, outside or on the
    // periphery of the Ellipse.
    
    UI_Rectangle BoundingRectangle() const;
    // Return the bounding rectangle of the ellipse.

    bool Includes (const UI_Point& p) const;
    // Return TRUE if {\tt p} is either inside or on the periphery of the
    // Ellipse.
    
    bool IntersectsBoundary (const UI_Rectangle& r) const;
    // Return TRUE if the rectangle {\tt r} intersects the ellipse's
    // periphery. Return FALSE if the rectangle is either entirely inside or
    // entirely outside the ellipse.

    UI_Point PointAtAngle (double angleInDegrees) const;
    // Return the point on the ellipse's periphery at the given angle. This
    // point is obtained by drawing a vector from the ellipse's origin that
    // subtends the given angle with respect to the horizontal, and
    // determining where this vector intersects the ellipse's periphery.
    //
    // The angle is reckoned counterclockwise from the horizontal. So 90
    // degrees is vertical upwards.
    
    UI_Ellipse operator+  (const UI_Vector&) const;
    // Return the Ellipse obtained by translating this Ellipse by the
    // given vector.

    virtual void operator+= (const UI_Vector& p) {*this = *this + p;};
    // Move this Ellipse by the given vector.
    
    virtual UI_Ellipse& operator= (const UI_Ellipse& e);
    // Assign {\tt e} to this Ellipse.

    void operator= (const CL_Object& o);
    
    const char* ClassName() const {return "UI_Ellipse";};

    CL_Object* Clone () const {return new UI_Ellipse (*this);}
    

protected:
    UI_Point _origin;
    long     _majorAxis;
    long     _minorAxis;

};



#endif /* _ellipse_h_ */
