

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

#if defined(__GNUC__)
#pragma implementation
#endif



#include "ui/graphic.h"
#include "ui/rectangl.h"
#include "ui/point.h"


bool UI_GraphicObject::ReshapeTo (const UI_Point&, const UI_Point&)
{
    return FALSE;
}

bool UI_GraphicObject::Fill   (UI_DrawingSurface&) const
{
    return FALSE;
}

UI_HitTest UI_GraphicObject::HitTest (const UI_Point& p) const
{
    return BoundingRectangle().HitTest (p);
}


bool UI_GraphicObject::IntersectsBoundary (const UI_Rectangle& r) const
{
    return BoundingRectangle().IntersectsBoundary (r);
}



UI_Point UI_GraphicObject::Center () const
{
    return BoundingRectangle().Center ();
}



UI_Rectangle UI_GraphicObject::BoundingRectangle () const
{
    NotImplemented ("BoundingRectangle");
    return UI_Rectangle (0, 0, 0, 0);
}


bool UI_GraphicObject::IsContainedIn (const UI_Rectangle& r) const
{
    return BoundingRectangle().IsContainedIn (r);
}
