

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#include <math.h>

#include "base/defs.h"
#include "ui/grutils.h"


#ifndef M_PI
#define M_PI 3.1415926535897932
#endif

double DegToRad (double deg)
{
    bool negative = FALSE;
    if (deg < 0) {
        negative = TRUE;
        deg = -deg;
    }
    // Reduce it modulo 360
    deg = ((long) deg) % 360 + (deg - ((long) deg));
    double rad = M_PI * deg / 180;
    if (negative)
        rad = 2 * M_PI - rad;
    return rad;
}

double RadToDeg (double rad)
{
    double deg = rad * 180 / M_PI;
    bool negative = FALSE;
    if (deg < 0) {
        negative = TRUE;
        deg = -deg;
    }
    // Reduce it modulo 360
    deg = ((long) deg) % 360 + (deg - ((long) deg));
    if (negative)
        deg = 360 - deg;
    return deg;
}
