




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma implementation
#endif


#include "ui/interval.h"


CL_Interval::CL_Interval (long start,long end)
{
    _low = start;
    _hi = end;
}

CL_Interval::CL_Interval ()
{
    _low = -1;
    _hi = -1;
}

CL_Interval::CL_Interval (const CL_Interval& i)
{
    _low = i._low;
    _hi = i._hi;
}



bool CL_Interval::operator== (const CL_Object& i) const
{

    if (_low == ((const CL_Interval&)i)._low &&
        _hi  == ((const CL_Interval&)i)._hi)
        return TRUE;
    return FALSE;
}


void CL_Interval::operator= (const CL_Interval& i) 
{
    if (!PrepareToChange())
        return;
    _low = i._low;
    _hi = i._hi;
    Notify ();
}


void CL_Interval::Low (long v)
{
    if (!PrepareToChange())
        return;
    _low = minl (_hi, v);
    Notify ();
}


void CL_Interval::High (long v)
{
    if (!PrepareToChange())
        return;
    _hi = maxl (_low, v);
    Notify ();
}


CL_String CL_Interval::AsString() const
{
    CL_String s;
    s.AssignWithFormat ("(%ld, %ld)", _low, _hi);
    return s;
}


CL_Interval CL_Interval::operator+ (long n) const
{
    return CL_Interval (_low + n, _hi + n);
}


CL_Interval CL_Interval::operator- (long n) const
{
    return CL_Interval (_low - n, _hi - n);
}


