
#ifndef _label_h_
#define _label_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma interface
#endif



#include "ui/simple.h"

  
// Label is a SimpleVObject that denotes a ``static'' string label, one
// whose contents can be modified by the application but not by the user
// of the application. Its
// title and model are the same entity; 
// modifying either of them modifies the displayed string.


class YACL_UI UI_CompositeVObject;

class YACL_UI UI_Label: public UI_SimpleVObject {

public:
    UI_Label (UI_VisualObject* parent, 
              const UI_Rectangle& r, UI_ViewID id = -1);
    // Constructor: use this object's own model. The model will be
    // destroyed when this object is destroyed.

    UI_Label (UI_VisualObject* parent, CL_String* model,
              const UI_Rectangle& r, UI_ViewID id);
    // Constructor: use the given string (second parameter) as model. The
    // model string is viewed as ``borrowed'', so it
    // is not this object's responsibility to destroy the model.

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_Label (UI_CompositeVObject* parent, UI_ViewID id, UI_ViewHandle h);
    // [MS-Windows-specific] Constructor for resource-based construction.

#endif
    
    virtual bool SetTextStyle (UI_TextStyle style);
    // Set the style of text in this label. See {\tt uidefs.h} for the
    // declaration of the {\tt UI_TextStyle} enumeration.

    virtual UI_TextStyle TextStyle() const;
    // Return the current text style of this label.. See {\tt uidefs.h} for the
    // declaration of the {\tt UI_TextStyle} enumeration.

    static void SetDefaultTextStyle (UI_TextStyle s);
    // Set the default text style for all Label objects. After calling this
    // method, you can still invoke the non-static method {\tt SetTextStyle}
    // to change the style for indivdual Label objects.
    
    virtual UI_WindowClass WindowClass () const;
    
    const char* ClassName() const { return "UI_Label";};

protected:

#if defined(__X_MOTIF__)
    void _SetupStyle (void*, short&);
    // [X-Motif-specific, for YACL internal use only] Set up the resources
    // for the label widget.

#elif defined(__X_YACL__)
    bool MakeVisualElement ();
    // Override the inherited method.
    
    bool HandleEvent (UI_Event* e);
    // Override the inherited method.

    void DrawVisualElement ();
    
#endif
    void _PrivateInitialize ();
    
    bool _TitleChanged ();

    ~UI_Label(){};
    // Protected destructor, to discourage direct delete operations.

    UI_TextStyle _textStyle;
};



#endif
