




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma implementation
#endif


// A default main program included with YACL's user interface library

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#include <string.h>
#include <windows.h>
#include "base/bytstrng.h"
#endif

#include "base/string.h"
#include "base/strgseq.h"
#include "ui/applic.h"


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                   LPSTR lpCmdLn, int nCmdShow)
#elif defined(__X_MOTIF__)  || defined(__X_YACL__)|| defined(__OS2__)
int main (int argc, char* argv[])
#endif
    
{
    bool ownApp = FALSE;
    UI_Application* theApp = YACLApp();
    if (!theApp) {
        theApp = new UI_Application;
        ownApp = TRUE;
    }
    
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    theApp->Initialize (hInstance, hPrevInstance, lpCmdLn, nCmdShow);
    static const short MAX_FILE_NAME_LEN = 257;
    CL_ByteString progFileName (MAX_FILE_NAME_LEN);
    GetModuleFileName (hInstance, (char*) progFileName.AsPtr(),
                       MAX_FILE_NAME_LEN);
    CL_StringSequence fld = CL_String (lpCmdLn).Split ();
    short n = fld.Size();
    int argc = n+1;
    char** argv = new char* [argc+1];
    argv[0] = (char*)  progFileName.AsPtr();
    short i;
    for (i = 0; i < n; i++) {
        argv[i+1] = new char [fld[i].Size() + 1];
        strcpy (argv[i+1], (const char*) fld[i]);
    }
    argv[argc] = 0;
#elif defined(__X_MOTIF__)  || defined(__X_YACL__)|| defined(__OS2__)
    theApp->Initialize (argc, argv);
#endif

    int returnVal =  theApp->Main (argc, argv);

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    for (i = 1; i < argc; i++) {
        delete [] argv[i];
    }
    delete [] argv;
#endif
    if (ownApp)
        delete theApp;
    return returnVal;
    
}
