

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
#define OEMRESOURCE
#include <windows.h>

#elif defined (__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <X11/Intrinsic.h>
#endif

#include "io/binfile.h"

#include "ui/mbitmap.h"
#include "ui/cntroler.h"
#include "ui/dsplsurf.h"
#include "ui/color.h"

extern "C" {
    double pow (double, double);
};

#define TO_LONG(a,b,c,d) ((((long) b) << 24) | (((long) c) << 16) | \
                       (((long) d) << 8)  | ((long) a))
#define TO_SHORT(a,b) ((((short) b) << 8) | (((short) a)))

// inline void SWAPBYTES (uchar &a, uchar &b)
// {
//     uchar t = a;
// 
//     a = b;
//     b = t;
// }


struct IconDirEntry {
    uchar  width;
    uchar  height;
    uchar  ccount;
    uchar  res;
    ushort planes;
    ushort bcount;
    ulong  binres;
    uchar  offseta;
    uchar  offsetb;
    uchar  offsetc;
    uchar  offsetd;
};

struct IconHeader {
    unsigned short res;
    unsigned short type;
    unsigned short count;
};

struct BitmapInfoHeader {
    ulong  size;
    uchar  width[4];
    uchar  height[4];
    ushort planes;
    uchar  bcount[2];
    ulong  compression;
    ulong  bsize;
    ulong  hres;
    ulong  vres;
    ulong  ncolors;
    ulong  nicolors;
};



inline ulong _MakeLong (uchar data[4])
{
    long d = (long) data [3];
    long c = (long) data [2];
    long b = (long) data [1];
    long a = (long) data [0];

    return ((d << 24) | (c << 16) | (b << 8) | (a));
}


inline ulong _MakeShort (uchar data[2])
{
    long b = (long) data [1];
    long a = (long) data [0];

    return ((b << 16) | (a));
}


UI_MaskedBitmap::UI_MaskedBitmap (bool inv)
: _invertBg (inv)
{
//     _handle       = 0;
//     _info.width   = 0;
//     _info.height  = 0;
//     _info.bits    = NULL;
}


UI_MaskedBitmap::UI_MaskedBitmap (const char* name, UI_DrawingSurface* sfc,
                                  bool inv)
: _invertBg (inv)
{
    CL_BinaryFile bmf (name);
    //    BitmapInfoHeader  bmih ;
    IconHeader        ih   ;
    IconDirEntry      ideh ;
    //    RGBQuad          *cquad;
    long bmheight = 0, bmwidth = 0, bmoffset = 0;
    
    if (!bmf.Valid()) {
        CL_Error::Warning ("UI_MaskedBitmap::UI_MaskedBitmap: Invalid"
                           " bitmap file");
        return;
    }

    bmf.Read ((uchar *) &ih, sizeof (IconHeader));
    bmf.Read ((uchar *) &ideh, sizeof (IconDirEntry));
    bmoffset = TO_LONG (ideh.offseta, ideh.offsetb, ideh.offsetc,
                        ideh.offsetd);
    bmf.SeekTo (bmoffset);
    BitmapInfoHeader  bmih;
    if (bmf.Read ((uchar *) &bmih, sizeof(BitmapInfoHeader)) != sizeof(bmih)) {
        CL_Error::Warning ("UI_Bitmap::ReadFrom: Read failed on info: %s",
                           bmf.AsString().AsPtr());
        return;
    }
    short numcbits  = _MakeShort (bmih.bcount);
    UI_BitmapData data;
    if (!data.ReadData (bmf, _MakeLong (bmih.width),
                        _MakeLong (bmih.height)/2,
                        numcbits))
        return;
    if (!_CreateBitmapFromData (data, sfc))
        return;

//     if (bmf.Read ((uchar *) &bmih, sizeof(BitmapInfoHeader)) != sizeof(bmih)) {
//         CL_Error::Warning ("UI_MaskedBitmap::UI_MaskedBitmap: Read failed"
//                            " on info");
//         return;
//     }
// 
//     _info.numcbits  = TO_SHORT (bmih.bcounta, bmih.bcountb);
//     short numcolors = (short) pow (2, (double) _info.numcbits);
// 
//     if (_info.numcbits != 24) {
//         cquad = new RGBQuad [numcolors+2];
//         for (short i = 0; i < numcolors; ++i)
//             bmf.Read ((uchar *)&(cquad [i]), sizeof (RGBQuad));
//     }
//     bmheight = ideh.height;
//     bmwidth  = ideh.width ;
//     numcolors = ideh.ccount;
// 
//     uchar* bits = (uchar *) new uchar [bmwidth * bmheight];
//     ushort numreadbytes = bmwidth * bmheight/(8/_info.numcbits);
// 
//     bmf.Read ((uchar *) bits, numreadbytes);
//
    long maskSizeBytes = data.Width() * data.Height() / 8;
    uchar* andbits = (uchar *) new uchar [maskSizeBytes];
    bmf.Read (andbits, maskSizeBytes);
    _andMask        = andbits;    
//     _info.height    = bmheight;
//     _info.width     = bmwidth;
//     _info.numcbits  = TO_SHORT (bmih.bcounta, bmih.bcountb);
//     _info.numcolors = numcolors;
//     _info.bits      = bits  ;
//     _info.cinfo     = new UI_BitmapInfo::ColorInfo [numcolors];
// 
//     for (short i = 0; i < numcolors; ++i ) {
//         _info.cinfo[i].red   = cquad [i].red;
//         _info.cinfo[i].green = cquad [i].green;
//         _info.cinfo[i].blue  = cquad [i].blue;
//     }
// 
//     _CreateBitmapFromInfo (_info, s);
// 
//     UI_BitmapData data (bmwidth, bmheight,
//                         TO_SHORT(bmih.bcounta, bmih.bcountb),
//                         numcolors, t);
//     _CreateBitmapFromData (data, sfc);
//     delete [] cquad;
}



UI_MaskedBitmap::UI_MaskedBitmap (const UI_BitmapData& bi, 
                                  UI_DrawingSurface* s, uchar *andmask,
                                  bool inv)
: _invertBg (inv)
{
    _andMask = andmask;
    _CreateBitmapFromData (bi, s);
}




UI_MaskedBitmap::~UI_MaskedBitmap ()
{
    if (_andMask)
        delete [] _andMask;
}


bool UI_MaskedBitmap::DrawOn (UI_DrawingSurface& s, const UI_Point& p) const
{
    s.DrawMaskedBitmap (*this, _andMask, p);
    return TRUE;
}







