

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#include "ui/applic.h"
#include "ui/cntroler.h"
#include "ui/mdi.h"
#include "ui/dsplsurf.h"


UI_MDIMainWindow::UI_MDIMainWindow (const UI_Rectangle& shape,
                                    UI_MenuItemDescriptor* desc,
                                    UI_ViewID windowMenuId)
: UI_CompositeVObject (NULL, shape)
{
    _menuBar = new UI_MenuBar (this, desc);
    _windowMenuID = windowMenuId;
#if defined(__OS2__)
    _frameStyle |= WS_SYNCPAINT | WS_CLIPCHILDREN | WS_CLIPSIBLINGS;
#endif
}


UI_MDIMainWindow::~UI_MDIMainWindow ()
{
}


bool UI_MDIMainWindow::TileChildren ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SendMessage (_clientHandle, WM_MDITILE, 0, 0L);
#elif defined (__OS2__)
#endif
    return TRUE;
}


bool UI_MDIMainWindow::CascadeChildren ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SendMessage (_clientHandle, WM_MDICASCADE, 0, 0L);
#elif defined (__OS2__)
    static const short
        CASCADE_X_INITIAL   =  4,
        CASCADE_Y_INITIAL   =  4,
        CASCADE_X_INCREMENT = 30,
        CASCADE_Y_INCREMENT = 40;
    long x = CASCADE_X_INITIAL, y = CASCADE_Y_INITIAL;
    CL_ObjectSetIterator itr (_mdiChildren);
    while (itr.More()) {
        UI_MDIChild* c = (UI_MDIChild*) itr.Next();
        c->Shape().Origin (UI_Point (x, y));
        x += CASCADE_X_INCREMENT;
        y += CASCADE_Y_INCREMENT;
        if (x >= _shape.Width() - CASCADE_X_INCREMENT)
            x = 0;
        if (y >= _shape.Height() - CASCADE_Y_INCREMENT)
            y = 0;
    }
#endif
    return TRUE;
}


bool UI_MDIMainWindow::ArrangeChildIcons ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SendMessage (_clientHandle, WM_MDIICONARRANGE, 0, 0L);
#endif
    return TRUE;
}


bool UI_MDIMainWindow::CloseAllChildren ()
{
    return TRUE; // For now
}


UI_MDIChild* UI_MDIMainWindow::ActiveChild () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    HWND h = (HWND) SendMessage (_handle, WM_MDIGETACTIVE, 0, 0);
    UI_MDIChild* ch = (UI_MDIChild*) (*_Controller)[h];
    return ch;
#else
    return 0; // Default, for now
#endif
}



bool UI_MDIMainWindow::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    RECT shapeRect = _shape.AsMSRect ();
    if (!_parent || !_stickToParent)
        AdjustWindowRect (&shapeRect, _style, _menuBar ? TRUE : FALSE);
    short x = shapeRect.left;
    short y = shapeRect.top;
    short w = shapeRect.right - shapeRect.left;
    short h = shapeRect.bottom - shapeRect.top;
    UI_WindowClass class_name = WindowClass();
    HANDLE hInst = _Application->ProcessId();
    _handle = CreateWindow (WindowClass(), _title.AsPtr(),
                                 WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
                                 x, y, w, h, NULL, NULL, hInst, NULL);
    if (!_handle) {
        CL_String s;
        s.AssignWithFormat
            ("MDIMainWindow: CreateWindow failed:\nClass %s ID %d: %s",
             class_name, _id, _Application->ErrorString().AsPtr());
        CL_Error::Warning (s.AsPtr());
        return FALSE;
    }

    CLIENTCREATESTRUCT ccs;
    ccs.hWindowMenu  = 0;
    ccs.idFirstChild = 0;
    _clientHandle = CreateWindow ("mdiclient", NULL,
                                  WS_CHILD | WS_CLIPCHILDREN,
                                  0, 0, 0, 0, _handle, 0, hInst,
                                  (LPSTR) &ccs);
    if (!_clientHandle) {
        CL_String s;
        s.AssignWithFormat
            ("MDIMainWindow: CreateWindow failed:\nClass mdiclient ID %d: %s",
             _id, _Application->ErrorString().AsPtr());
        CL_Error::Warning (s.AsPtr());
        return FALSE;
    }
    ShowWindow (_handle, SW_SHOW);
    ShowWindow (_clientHandle, SW_SHOW);
    _Controller->MDIClientCreated (this);
    return TRUE;
#elif defined(__OS2__)
    return UI_CompositeVObject::MakeVisualElement ();
#endif
}


UI_WindowClass UI_MDIMainWindow::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return _YACLMDIFrameClassName;
#elif defined(__OS2__)
    return _YACLWindowClassName;
#else
#error MDI is not supported on this platform.
#endif
}

bool UI_MDIMainWindow::MenuBarCreated ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SetMenu (_handle, _menuBar->ViewHandle());
    UI_MenuItem* windowItem = _windowMenuID ? (*_menuBar)[_windowMenuID] :
        0;
    if (!windowItem)
        return FALSE;
#if defined(__MS_WINDOWS__)
    SendMessage (_clientHandle, WM_MDISETMENU, FALSE,
                 MAKELPARAM (_menuBar->ViewHandle(),
                             windowItem->ViewHandle()));
#else
    SendMessage (_clientHandle, WM_MDISETMENU, (WPARAM) _menuBar->ViewHandle(),
                 (LPARAM) windowItem->ViewHandle());
#endif
    DrawMenuBar (_handle);
#endif
    return TRUE;
}


void UI_MDIMainWindow::MDIChildCreated (UI_MDIChild* c)
{
    _mdiChildren.Add (c);
}


void UI_MDIMainWindow::MDIChildDestroyed (UI_MDIChild* c)
{
    _mdiChildren.Remove (c);
}


bool UI_MDIMainWindow::Paint (const UI_Rectangle&)
{
    UI_DisplaySurface& sfc = CreateDisplaySurface ();
    sfc.ClearDisplay ();
    DestroyDisplaySurface ();
    return FALSE;
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
LRESULT UI_MDIMainWindow::DefaultProc (HWND h, UINT msg, WPARAM wParam,
                                       LPARAM lParam)
{
    return DefFrameProc (h, _clientHandle, msg, wParam, lParam);
}

#endif


// ----------------------------- MDIChild methods --------------------




UI_MDIChild::UI_MDIChild (UI_MDIMainWindow* parent, const UI_Rectangle&
                          shape, UI_ViewID id)
: UI_CompositeVObject (parent, shape, id)
{
#if defined(__OS2__)
    _frameStyle |= WS_SYNCPAINT | WS_CLIPCHILDREN | WS_CLIPSIBLINGS;
#endif
    parent->MDIChildCreated (this);
}



bool UI_MDIChild::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    MDICREATESTRUCT mcs;
    HANDLE hInst = _Application->ProcessId();
    mcs.szClass    = _YACLMDIChildClassName;
    mcs.hOwner     = hInst;
    mcs.x          = CW_USEDEFAULT;
    mcs.cx         = CW_USEDEFAULT;
    mcs.y          = _shape.Width();
    mcs.cy         = _shape.Height ();
    mcs.style      = 0;
    mcs.szTitle    = _title.AsPtr();
    _handle = (HWND) SendMessage (((UI_MDIMainWindow*)_parent)->ClientHandle(),
                                  WM_MDICREATE, 0, (LONG) &mcs);
    if (!_handle) {
        CL_String s;
        s.AssignWithFormat
            ("MDIChild: CreateWindow failed:\nClass %s ID %ld: %s",
             mcs.szClass, _id, _Application->ErrorString().AsPtr());
        CL_Error::Warning (s.AsPtr());
        return FALSE;
    }
    ShowWindow(_handle, SW_SHOW);
    return TRUE;
#elif defined(__OS2__)
    _shape.Origin (UI_Point (10, 10));
    return UI_CompositeVObject::MakeVisualElement ();
#endif
}


#if defined(__OS2__)
HWND UI_MDIChild::ParentHandle () const
{
    return _parent->ViewHandle();
}
#endif


bool UI_MDIChild::DestroyVisualElement ()
{
    ((UI_MDIMainWindow*) _parent)->MDIChildDestroyed (this);
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SendMessage (((UI_MDIMainWindow*)_parent)->ClientHandle(),
                 WM_MDIDESTROY, (WPARAM) _handle, 0);
#endif
    return TRUE;
}

bool UI_MDIChild::Paint (const UI_Rectangle& r)
{
    _FillWithBgColor (r);
    return FALSE;
}


#if defined(__OS2__)

bool UI_MDIChild::HandleEvent (UI_Event* e)
{
    if (e) {
        NativeEventStruct* evt = e->NativeEvent();
        if (evt && evt->msg == WM_MINMAXFRAME) {
            PSWP pSwp = (PSWP) evt->mp1;
            if (pSwp && (pSwp->fl & SWP_RESTORE))
                _parent->Invalidate ();
        }
    }
    return UI_CompositeVObject::HandleEvent (e);
}

#endif



#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
long UI_MDIChild::WindowProcHook (HWND hWnd, UINT message, WPARAM wParam,
                                  LPARAM lParam)
{
    if (message == WM_GETMINMAXINFO)
        return DefaultProc (hWnd, message, wParam, lParam);
    return UI_VObjCollection::WindowProcHook (hWnd, message, wParam,
                                              lParam);
}

LRESULT UI_MDIChild::DefaultProc (HWND h, UINT msg, WPARAM wParam,
                                  LPARAM lParam)
{
    return DefMDIChildProc (h, msg, wParam, lParam);
}

#endif

