

#ifndef _mdi_h_ /* Thu Dec 14 14:46:19 1995 */
#define _mdi_h_


/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


// A start at  MDI classes for YACL.


#include "base/objset.h"

#include "ui/composit.h"
#include "ui/menu.h"


class YACL_UI UI_MDIChild;

class YACL_UI UI_MDIMainWindow: public UI_CompositeVObject {

public:
    UI_MDIMainWindow (const UI_Rectangle& shape,
                      UI_MenuItemDescriptor* items,
                      UI_ViewID  windowMenuId);
    // Constructor: Create an MDI main window with the given shape, with a
    // MenuBar as described by {\tt items}, in which the top-level item
    // with view id {\it windowMenuId} will contain menu items for the
    // MDI children.
    
    ~UI_MDIMainWindow ();

    bool TileChildren ();
    // Tile the children of the main window.

    bool CascadeChildren ();
    // Cascade the children.

    bool ArrangeChildIcons ();

    bool CloseAllChildren ();

    UI_MDIChild* ActiveChild () const;
    // Return a pointer to the currently active MDI child.
    
    UI_WindowClass WindowClass () const;

    const char* ClassName () const {return "UI_MDIMainWindow";};
    
protected:
    bool MakeVisualElement ();

    bool MenuBarCreated ();

    bool Paint (const UI_Rectangle&);
    
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ViewHandle _clientHandle;
#endif
    UI_ViewID     _windowMenuID;
    CL_ObjectSet  _mdiChildren;

public:
    virtual void MDIChildCreated (UI_MDIChild*);
    // [For YACL internal use only] Called by the MDI child to tell us of
    // its creation.

    virtual void MDIChildDestroyed (UI_MDIChild*);
    // [For YACL internal use only] Called by the MDI child to tell us of
    // its destruction.

    
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ViewHandle ClientHandle () const {return _clientHandle;};
    // [MS-Windows specific, for YACL internal use only] Return the handle
    // of the client window.

    virtual LRESULT DefaultProc (HWND h, UINT msg, WPARAM wParam,
                                 LPARAM lParam);
    // [MS Windows specific, YACL internal use only] Default processing.
    
#endif
};




class YACL_UI UI_MDIChild: public UI_CompositeVObject {

public:
    UI_MDIChild (UI_MDIMainWindow* parent, const UI_Rectangle& shape,
                 UI_ViewID id);

    const char* ClassName () const {return "UI_MDIChild";};
    
protected:
    bool MakeVisualElement ();

    bool DestroyVisualElement ();
    
    bool Paint (const UI_Rectangle&);
    
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    virtual LRESULT DefaultProc (HWND h, UINT msg, WPARAM wParam,
                                 LPARAM lParam);
    // [MS Windows specific, YACL internal use only] Default processing.
    
public:
    long WindowProcHook (HWND hWnd, UINT message, WPARAM wParam,
                         LPARAM lParam);
    // [MS Windows specific, YACL internal use only]
    
#endif

#if defined(__OS2__)
    HWND ParentHandle () const;
    // [Specific to OS/2 and Windows. YACL internal use only.]

    bool HandleEvent (UI_Event* e);
    // [Specific to OS/2 and Windows. YACL internal use only.] Override
    // the inherited method.
    
#endif
};




#endif /* _mdi_h_ */
