




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif


#include "ui/pen.h"
#include "ui/color.h"
#include "ui/visualob.h"
#include "ui/dsplsurf.h"
#include "ui/cntroler.h"

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
 
#include <windows.h>
static short getPatternFromMS (UI_PenPattern );
#elif defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <X11/Intrinsic.h>
static long getPatternFromX (UI_PenPattern);
#endif

UI_Pen::UI_Pen (UI_DrawingSurface* ct, short sz, UI_Color cl,
                UI_PenPattern pt)
: UI_DisplayResource (ct)
{
    _size = sz;
    _color = cl;
    _pattern = pt;
    _handle = 0;
    _Setup ();
}

void UI_Pen::_Setup ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if(_handle) {
        SelectObject (_clientCtxt->Handle(), GetStockObject (BLACK_PEN));
        DeleteObject (_handle);
    }
    short msp = getPatternFromMS (_pattern);
    _handle = (UI_ResourceHandle) CreatePen (msp, _size, _color.NativeForm());
    SelectObject (_clientCtxt->Handle(), _handle);
    SetTextColor (_clientCtxt->Handle(), _color.NativeForm());
#elif defined(__OS2__)
    HPS hps = (HPS) _clientCtxt->Handle();
    GpiSetLineWidth (hps, MAKEFIXED (_size, 0));
    GpiSetLineType (hps, OS2Pattern ());
//     if (!GpiSetColor (hps, _color.NativeForm()))
//         UI_Application::PMError();
#elif defined(__X_MOTIF__)
    Display* dpy = YACLApp()->AppDisplay();
    XSetLineAttributes (dpy, _clientCtxt->Handle(), _size,
                        getPatternFromX (Pattern ()),
                        CapButt, JoinMiter);
    
    if (_pattern == UIPen_Dot || _pattern == UIPen_Dash) {
        XGCValues val;
        val.dashes = _pattern == UIPen_Dot ? 2 : 4;
        XChangeGC (dpy, _clientCtxt->Handle(), GCDashList, &val);
    }
#endif
}



UI_Pen::~UI_Pen()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle) {
        SelectObject (_clientCtxt->Handle(), GetStockObject (BLACK_PEN));
        DeleteObject (_handle);
    }
#elif defined(__X_MOTIF__)

#endif
}

void UI_Pen::Thickness (short sz)
{
    _size = sz;
    _Setup ();
}


void UI_Pen::Pattern (UI_PenPattern ptrn)
{
    _pattern = ptrn;
    _Setup ();
}

void UI_Pen::Color (const UI_Color& newColor)
{
    _color = newColor;
    _Setup();
}


void UI_Pen::operator= (const UI_PenDescriptor& p)
{
    _pattern = p.pattern;
    _size    = p.size;
    _color   = p.color;
    _Setup();
}

void UI_Pen::operator= (const CL_Object&)
{
    NotImplemented ("Operator= (const CL_Object&)");
}



UI_PenDescriptor UI_Pen::Descriptor () const
{
    return UI_PenDescriptor (_size, _color, _pattern);
}

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)

short getPatternFromMS(UI_PenPattern p)
{

    switch(p){

    case UIPen_None:
        return PS_NULL;
        
    case UIPen_Solid:
        return PS_SOLID;
    
    case UIPen_Dash:
        return PS_DASH;
    
    case UIPen_Dot:
        return PS_DOT;
        
    default:
        return PS_SOLID;
    }

}

#elif defined(__OS2__)

long UI_Pen::OS2Pattern () const
{
    switch (_pattern) {
    case UIPen_None:
        return LINETYPE_INVISIBLE;

    case UIPen_Dash:
        return LINETYPE_SHORTDASH;
    
    case UIPen_Dot:
        return LINETYPE_DOUBLEDOT;
        
    case UIPen_Solid:
    default:
        return LINETYPE_SOLID;
    }

}

#elif defined(__X_MOTIF__)
long getPatternFromX (UI_PenPattern p)
{
    switch (p){
    case UIPen_Solid:
        return LineSolid;

    case UIPen_Dash:
        return LineOnOffDash;

    case UIPen_Dot:
        return LineOnOffDash;

    default:
        return LineSolid;
    }

}

#endif

