#ifndef _pen_h_
#define _pen_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma interface
#endif



#include "ui/dsplrsrc.h"
#include "ui/color.h"
#include "ui/rectangl.h"


// The properties of the Pen class  determine the color and style in which
// lines are drawn on a DrawingSurface.

//[ Global
enum UI_PenPattern   {
    UIPen_None, UIPen_Solid, UIPen_Dash, UIPen_Dot
};
// This enumeration lists the supported pen patterns.
//] Global


class YACL_UI UI_PenDescriptor;
    

class YACL_UI UI_Pen : public UI_DisplayResource {

public:
    UI_Pen (UI_DrawingSurface* ctxt, short pen_size = 1,
            UI_Color pen_color = UI_Color (UIColor_Black),
            UI_PenPattern patrn = UIPen_Solid);
    // Create a Pen instance for the given DrawingSurface, with the given
    // pen size, color and pattern.
    
    ~UI_Pen ();
    // Destructor.

    // ------------------  Attribute querying methods ----------------

    short         Thickness ();
    // Return the thickness of the pen, in pixels.

    UI_PenPattern Pattern ();
    // Return the pattern of the pen.

    const UI_Color&      Color();
    // Return the color of the pen.

    UI_PenDescriptor Descriptor () const;
    // Return a descriptor for this pen.
    
    // ------------------ Attribute setting methods ------------------
    
    void Thickness (short size);
    // Set the thickness of the pen. Under Microsoft Windows, Pens with
    // thickness greater than one pixel will always have pattern {\tt
    // UIPen_Solid}. This is a limitation imposed by Windows.
    
    void Pattern (UI_PenPattern );
    // Set the pen's pattern to the given value.

    void Color (const UI_Color& newColor);
    // Set the pen's color to {\tt newColor}.

    void operator= (const UI_PenDescriptor&);
    // Assignment operator.

    void operator=   (const CL_Object&);


    // ---------------------- Basic methods ---------------------------
    
    const char* ClassName () const { return "UI_Pen";};    


    // ------------------- End public protocol ------------------------
    
protected:

    short          _size;
    UI_Color       _color;
    UI_PenPattern  _pattern;

    void           _Setup();
    // Called to set up the pen in the context of a particular
    // DrawingSurface.

#if defined(__OS2__)
public:
    long OS2Pattern () const;
    // [OS/2-specific, internal use only]

#endif
    
};


// A PenDescriptor merely describes the attributes of a Pen. In contrast, a
// Pen instance might include platform-specific data that relates the
// attributes to a particular DrawingSurface.

class YACL_UI UI_PenDescriptor: public CL_Object {

public:
    UI_PenDescriptor (short sizeInPixels, const UI_Color& clr,
                      UI_PenPattern p)
    : size (sizeInPixels), color (clr), pattern (p) {};

    UI_PenDescriptor (const UI_PenDescriptor& c)
    : size (c.size), color (c.color), pattern (c.pattern) {};

    ~UI_PenDescriptor () {};
    
    const char* ClassName () const {return "UI_PenDescriptor";};
    
    short         size;
    UI_Color      color;
    UI_PenPattern pattern;
};




inline short UI_Pen::Thickness()
{
    return _size;
}


inline UI_PenPattern UI_Pen::Pattern()
{
    return _pattern;
}

inline const UI_Color& UI_Pen::Color()
{
    return _color;
}





#endif

