

#ifndef _piewedge_h_ /* Thu Jan  5 09:34:33 1995 */
#define _piewedge_h_



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// This is a GraphicObject representing a pie wedge of an ellipse, made up
// of an arc and lines joining the ends of the arc to the center. This is a
// closed figure.
//
// Like the other GraphicObjects, the PieWedge views its co-ordinate space as
// an abstract space not tied to any particular device. But its {\tt DrawOn}
// and {\tt Fill} methods view its dimension units as pixels.

#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/arc.h"


class YACL_UI UI_Arc;
class YACL_UI UI_Ellipse;

class YACL_UI UI_PieWedge: public UI_GraphicObject {

public:
    UI_PieWedge (const UI_Rectangle& boundingRect, long startAngleDeg64, long
                 subtendedDeg64);
    // Construct a pie wedge of an ellipse. The PieWedge is part of the
    // ellipse whose
    // bounding rectangle is {\tt boundingRect}. Its starting point is at an
    // angle {$d$} degrees from the 3-o'clock position of {\tt boundingRect}
    // where $d = {\tt startAngleDeg64} * 64$, and it subtends an angle $s$
    // at the center of the ellipse, where $s = {\tt subtendedDeg64} * 64$,

    UI_PieWedge (const UI_Point &p1, const UI_Point &p2,
                 const UI_Point& origin);
    // Construct an arc of an ellipse with the points p1, p2 being the
    // start point and the end point and the origin being the center of
    // the ellipse.

    UI_PieWedge ();
    // Default constructor: construct a piewedge of an ellipse with zero
    // axes.
    
    UI_PieWedge (const UI_PieWedge& w) {*this = w;};
    // Copy constructor.
    
    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point (0,0)) const;
    // Draw the ellipse on the surface {\tt sfc} (overrides inherited
    // method).

    bool Fill (UI_DrawingSurface& sfc) const;
    // Fill the interior of this PieWedge on the surface {\tt sfc} with the
    // latter's current brush. Return TRUE on success.
    
    bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);
    // Override method inherited from GraphicObject. The implementation
    // reshapes the ellipse so that its bounding rectangle is the rectangle
    // whose diagonally opposite points are p1 and p2.

    UI_Rectangle BoundingRectangle() const;
    // Returns the bounding rectangle of the ellipse of which this pie wedge
    // is part.

    UI_PointPair EndPoints() const;
    // Return the end-points of the arc of the pie wedge. (See {\tt
    // ui/point.h} for the declaration of {\tt UI_PointPair}).

    UI_HitTest HitTest (const UI_Point& p) const;
    // Hit testing: overrides method inherited from Graphic. Return one of
    // the HitTest enumeration values according to whether {\tt p} is
    // inside, outside or on the periphery of this PieWedge.
    
    bool IntersectsBoundary (const UI_Rectangle& r) const;
    // Return TRUE if {\tt r} intersects the boundary of this PieWedge. This
    // overrides the inherited method.
    
    UI_PieWedge operator+  (const UI_Vector&) const;
    // Return the PieWedge obtained by translating this PieWedge by the
    // given vector.

    void operator+= (const UI_Vector& p) {*this = *this + p;};
    // Translate this PieWedge by Vector {\tt p}.

    bool MoveTo (const UI_Point& p);
    // Move this PieWedge so that the center of its ellipse is at {\tt p}.
    // Return TRUE if successful, FALSE if a pre-change dependent refused
    // permission.
    
    void operator= (const CL_Object& o);
    // Cast {\tt o} down to a PieWedge and assign it to this object.

    virtual UI_PieWedge& operator= (const UI_PieWedge& w);
    // Assign {\tt w} to this object.
    
    long StartAngle() const {return _startAngle;};
    // Return the start angle of the pie wedge, reckoned from the 3-o'clock
    // position in sixty-fourths of a degree.

    long SubtendedAngle() const {return _subtAngle;};
    // Return the subtended angle of the pie wedge in sixty-fourths of a
    // degree.

    UI_Ellipse Ellipse() const;
    // Return the Ellipse of which this PieWedge is part.

    virtual bool StartAngle (long startAngle64);
    // Set the start angle of this PieWedge. The parameter is in
    // sixty-fourths of a degree. Return TRUE on success, FALSE on failure
    // (e.g., a pre-change dependent refused permission).

    virtual bool SubtendedAngle (long subtAngle64);
    // Set the subtended angle of this PieWedge. The parameter is in
    // sixty-fourths of a degree. Return TRUE on success, FALSE on failure
    // (e.g., a pre-change dependent refused permission).

    virtual bool Origin (const UI_Point& origin);
    // Set the center of this PieWedge to {\tt origin}. Return TRUE on
    // success, FALSE on failure (e.g., a pre-change dependent refused
    // permission).
    
    const char* ClassName() const {return "UI_PieWedge";};

    CL_Object* Clone () const {return new UI_PieWedge (*this);}
    
protected:

    UI_Rectangle _boundingEllipse;
    long         _startAngle  ;
    long         _subtAngle   ;
    UI_Arc       _arc         ;

};



#endif /* _piewedge_h_ */
