




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#if defined(__GNUC__)
#pragma implementation
#endif

#include <math.h>


#include "ui/point.h"
#include "ui/dwgsurf.h"
#include "ui/rectangl.h"
#include "ui/vector.h"

#if defined(__GNUC__)
#include "base/cmparatr.cxx"
template class CL_Comparator<UI_Point>;
template class CL_Iterator<UI_Point>;
template class CL_Basics<UI_Point>;
#endif

//
//------------------Construction-----------------------------
//


UI_Point::UI_Point (long px, long py)
{
    x = px;
    y = py;
}


UI_Point::UI_Point (const UI_Point& p)
{
    x = p.x;
    y = p.y;
}


UI_Point UI_Point::operator+ (const UI_Vector& p) const
{
    return UI_Point (x + p.X(), y + p.Y());
}



//
//-----------Other member Functions--------------------------
//

void UI_Point::operator= (const CL_Object& p) 
{
    if (p.IsA (*this))
        *this = (const UI_Point&) p; // The op= does the notification
}


void UI_Point::operator= (const UI_Point& q)
{
    if (this == &q || !PrepareToChange())
        return;
    x = q.x;
    y = q.y;
    Notify ();
}


short UI_Point::Compare (const UI_Point& p) const
{
    if (x != p.x)
        return x < p.x ? -1 : 1;
    if (y != p.y)
        return y < p.y ? -1 : 1;
    return 0;
}


short UI_Point::Compare (const CL_Object& o) const
{
    if (o.IsA (*this))
        return Compare ((const UI_Point&) o);
    return this < ((const UI_Point*) &o) ? -1 : 1; // Should really throw an
                                                   // exception here?
}


//
//---------------Virtual member functions from CL_Object-------
//

bool UI_Point::operator== (const CL_Object& p) const
{
    if (!IsA (p))
        return FALSE;
    register const UI_Point& q = (const UI_Point&) p;
    if (q.x != x || q.y != y)
        return FALSE;
    return TRUE;
}


CL_String UI_Point::AsString() const
{
    CL_String s;
    s.AssignWithFormat ("(%ld, %ld)", x, y);
    return s;
}



void  UI_Point::AddToX (long value)
{
    if (!PrepareToChange())
        return;
    x += value;
    Notify ();
}

void  UI_Point::AddToY (long value)
{
    if (!PrepareToChange())
        return;
    y += value;
    Notify ();
}


double UI_Point::DistanceFrom (const UI_Point& p) const
{
    double xVal = x - p.x, yVal = y - p.y;
    return sqrt ((double) (xVal * xVal) + (yVal * yVal));
}


UI_Point UI_Point::operator- (const UI_Vector& p) const
{
    return UI_Point (x - p.X(), y - p.Y());
}


bool UI_Point::DrawOn (UI_DrawingSurface& sfc, const UI_Point& p) const
{
    sfc.DrawPoint (*this + UI_Vector (p));
    return TRUE;
}

UI_Rectangle UI_Point::BoundingRectangle () const
{
    return UI_Rectangle (x, y, 1, 1);
}





