


/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/pswdedit.h"


UI_PasswordEditor::UI_PasswordEditor (UI_VisualObject* parent,
                                      const UI_Rectangle& shape,
                                      UI_ViewID id)
: UI_StringEditor (parent, shape, id)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style |= ES_PASSWORD;
#elif defined(__OS2__)
    _style |= ES_UNREADABLE;
#endif
}



#if defined(__X_MOTIF__)
bool UI_PasswordEditor::FilterChar (short& key)
{
    CL_String* model = (CL_String*) _model;
    model->Append (key);
    key = '*'; // Don't show the key
    return  TRUE;
}
#endif


CL_Object& UI_PasswordEditor::Model ()
{
#if defined(__X_MOTIF__)
    return *_model;
#else
    return UI_StringEditor::Model();
#endif
}

