

#ifndef _pswdedit_h_ /* Thu Aug 10 12:23:49 1995 */
#define _pswdedit_h_



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// PasswordEditor is a specialization of StringEditor to edit passwords. It
// echoes its typed password as asterisks. The application can query a
// PasswordEditor for its model, but cannot modify the model. Querying the
// model returns the actual password typed, as a String.
//
// Caveat: The X implementation does not support editing the text, i.e., the
// user cannot use delete or backspace in the password field. The OS/2 and
// Windows implementations, however, do support editing.

#include "ui/stred.h"

class YACL_UI UI_PasswordEditor: public UI_StringEditor {

public:
    UI_PasswordEditor (UI_VisualObject* parent, const UI_Rectangle& shape,
                       UI_ViewID id);
    // Constructor: Create a PasswordEditor with given parent, shape and
    // view id.



    CL_Object& Model ();
    // Override the inherited method.


#if defined(__X_MOTIF__)
protected:
    
    virtual bool FilterChar (short& key);
    // [X/Motif-specific] Override the inherited method.

    bool _ModelChanged () {return TRUE;};
    // [X/Motif-specific] Don't do anything, just return TRUE. This method
    // overrides the inherited one.

#endif
    
};

#endif /* _pswdedit_h_ */
