


#ifndef _scale_h_ /* Mon Apr 15 21:20:58 1996 */
#define _scale_h_


// A scale is a SimpleVisualObject representing an integer value that can be
// adjusted via a thumb. Its model is a CL_Integer.

class YACL_UI UI_Scale: public UI_SimpleVObject {

public:
    enum Orientation {Horizontal, Vertical};
    
    UI_Scale (UI_VObjCollection* parent, const UI_Rectangle& shape,
              UI_ViewID id, Orientation o = Horizontal);
    // Constructor: create  a Scale as child of {\tt parent}, with
    // the given shape and view id.

    CL_Interval& Range ();
    // Return a reference to the range of the scale. The return value may be
    // modified.

    CL_ClientSet& ClientSet ();
    // Return the set of clients for this scale. The application may
    // add to or remove from this Set, since this method returns a reference.

    //-------------Inherited SimpleVObject methods---------------


    UI_WindowClass WindowClass () const;
    
    const char* ClassName () const { return "UI_Scale";};

protected:

    virtual bool _RangeChanged ();

    virtual bool _ModelChanged ();

    

};    
    

#endif /* _scale_h_ */
